/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.NettyServerBossPoolBuilder;
import org.apache.camel.component.netty.NettyWorkerPoolBuilder;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTCPNettyServerBootstrapFactory
extends ServiceSupport
implements NettyServerBootstrapFactory {
    protected static final Logger LOG = LoggerFactory.getLogger(SingleTCPNettyServerBootstrapFactory.class);
    private ChannelGroup allChannels;
    private CamelContext camelContext;
    private ThreadFactory threadFactory;
    private NettyServerBootstrapConfiguration configuration;
    private ChannelInitializer<Channel> pipelineFactory;
    private ServerBootstrap serverBootstrap;
    private Channel channel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    @Override
    public void init(CamelContext camelContext, NettyServerBootstrapConfiguration configuration, ChannelInitializer<Channel> pipelineFactory) {
        this.camelContext = camelContext;
        this.configuration = configuration;
        this.pipelineFactory = pipelineFactory;
        this.allChannels = configuration.getChannelGroup() != null ? configuration.getChannelGroup() : new DefaultChannelGroup(SingleTCPNettyServerBootstrapFactory.class.getName(), (EventExecutor)ImmediateEventExecutor.INSTANCE);
    }

    @Override
    public void init(ThreadFactory threadFactory, NettyServerBootstrapConfiguration configuration, ChannelInitializer<Channel> pipelineFactory) {
        this.threadFactory = threadFactory;
        this.configuration = configuration;
        this.pipelineFactory = pipelineFactory;
        this.allChannels = configuration.getChannelGroup() != null ? configuration.getChannelGroup() : new DefaultChannelGroup(SingleTCPNettyServerBootstrapFactory.class.getName(), (EventExecutor)ImmediateEventExecutor.INSTANCE);
    }

    @Override
    public void addChannel(Channel channel) {
        this.allChannels.add((Object)channel);
    }

    @Override
    public void removeChannel(Channel channel) {
        this.allChannels.remove((Object)channel);
    }

    @Override
    public void addConsumer(NettyConsumer consumer) {
    }

    @Override
    public void removeConsumer(NettyConsumer consumer) {
    }

    protected void doStart() throws Exception {
        if (this.camelContext == null && this.threadFactory == null) {
            throw new IllegalArgumentException("Either CamelContext or ThreadFactory must be set on " + this);
        }
        this.startServerBootstrap();
    }

    protected void doStop() throws Exception {
        this.stopServerBootstrap();
    }

    protected void startServerBootstrap() throws Exception {
        Object socketAddress;
        Map<String, Object> options;
        EventLoopGroup bg = this.configuration.getBossGroup();
        EventLoopGroup wg = this.configuration.getWorkerGroup();
        if (bg == null) {
            bg = this.bossGroup = new NettyServerBossPoolBuilder().withNativeTransport(this.configuration.isNativeTransport()).withBossCount(this.configuration.getBossCount()).withName("NettyServerTCPBoss").build();
        }
        if (wg == null) {
            wg = this.workerGroup = new NettyWorkerPoolBuilder().withNativeTransport(this.configuration.isNativeTransport()).withWorkerCount(this.configuration.getWorkerCount()).withName("NettyServerTCPWorker").build();
        }
        this.serverBootstrap = new ServerBootstrap();
        if (this.configuration.getUnixDomainSocketPath() != null) {
            this.serverBootstrap.group(bg, wg).channel(EpollServerDomainSocketChannel.class);
        } else if (this.configuration.isNativeTransport()) {
            this.serverBootstrap.group(bg, wg).channel(EpollServerSocketChannel.class);
        } else {
            this.serverBootstrap.group(bg, wg).channel(NioServerSocketChannel.class);
        }
        this.serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)this.configuration.isKeepAlive());
        this.serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)this.configuration.isTcpNoDelay());
        this.serverBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)this.configuration.isReuseAddress());
        this.serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)this.configuration.isReuseAddress());
        this.serverBootstrap.childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.configuration.getConnectTimeout());
        if (this.configuration.getBacklog() > 0) {
            this.serverBootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.configuration.getBacklog());
        }
        if ((options = this.configuration.getOptions()) != null) {
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                String value = entry.getValue().toString();
                ChannelOption option = ChannelOption.valueOf((String)entry.getKey());
                if (EndpointHelper.isReferenceParameter((String)value)) {
                    String name = value.substring(1);
                    Object o = CamelContextHelper.mandatoryLookup((CamelContext)this.camelContext, (String)name);
                    this.serverBootstrap.option(option, o);
                    continue;
                }
                this.serverBootstrap.option(option, (Object)value);
            }
        }
        this.serverBootstrap.childHandler(this.pipelineFactory);
        LOG.debug("Created ServerBootstrap {}", (Object)this.serverBootstrap);
        if (this.configuration.getUnixDomainSocketPath() != null) {
            Path udsPath = Path.of(this.configuration.getUnixDomainSocketPath(), new String[0]).toAbsolutePath();
            LOG.info("ServerBootstrap binding to {}", (Object)udsPath);
            socketAddress = new DomainSocketAddress(udsPath.toFile());
        } else {
            LOG.info("ServerBootstrap binding to {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
            socketAddress = new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort());
        }
        ChannelFuture channelFuture = this.serverBootstrap.bind((SocketAddress)socketAddress).sync();
        this.channel = channelFuture.channel();
        this.allChannels.add((Object)this.channel);
    }

    protected void stopServerBootstrap() {
        if (this.configuration.getUnixDomainSocketPath() != null) {
            Path udsPath = Path.of(this.configuration.getUnixDomainSocketPath(), new String[0]).toAbsolutePath();
            LOG.info("ServerBootstrap unbinding from {}", (Object)udsPath);
        } else {
            LOG.info("ServerBootstrap unbinding from {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        }
        LOG.trace("Closing {} channels", (Object)this.allChannels.size());
        this.allChannels.close().awaitUninterruptibly();
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
            this.bossGroup = null;
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.workerGroup = null;
        }
    }
}

