/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(value="netty")
public class NettyConsole
extends AbstractDevConsole {
    public NettyConsole() {
        super("camel", "netty", "Netty", "Embedded Netty Server");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        List list = this.getCamelContext().getRoutes().stream().map(Route::getConsumer).filter(c -> NettyConsumer.class.getName().equals(c.getClass().getName())).collect(Collectors.toList());
        for (Consumer c2 : list) {
            NettyConsumer nc = (NettyConsumer)c2;
            NettyConfiguration conf = nc.getConfiguration();
            if (conf.isClientMode()) continue;
            sb.append(String.format("    %s:%s:%d\n", conf.getProtocol(), conf.getHost(), conf.getPort()));
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        List list = this.getCamelContext().getRoutes().stream().map(Route::getConsumer).filter(c -> NettyConsumer.class.getName().equals(c.getClass().getName())).collect(Collectors.toList());
        ArrayList<JsonObject> arr = new ArrayList<JsonObject>();
        for (Consumer c2 : list) {
            NettyConsumer nc = (NettyConsumer)c2;
            NettyConfiguration conf = nc.getConfiguration();
            if (conf.isClientMode()) continue;
            JsonObject jo = new JsonObject();
            jo.put((Object)"protocol", (Object)conf.getProtocol());
            jo.put((Object)"host", (Object)conf.getHost());
            jo.put((Object)"port", (Object)conf.getPort());
            arr.add(jo);
        }
        if (!arr.isEmpty()) {
            root.put((Object)"endpoints", arr);
        }
        return root;
    }
}

