/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.camel.spi.Metadata;

public final class NettyHttpConstants {
    public static final String CONTENT_TYPE_JAVA_SERIALIZED_OBJECT = "application/x-java-serialized-object";
    public static final String CONTENT_TYPE_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    @Deprecated
    public static final String HTTP_RESPONSE_TEXT = "CamelHttpResponseText";
    @Metadata(description="If the user was authenticated using HTTP Basic then this header is added\nwith the value `Basic`.", javaType="String")
    public static final String HTTP_AUTHENTICATION = "CamelHttpAuthentication";
    @Metadata(description="To set the content-type of the HTTP body. For example:\n`text/plain; charset=\"UTF-8\"`.", javaType="String")
    public static final String CONTENT_TYPE = "Content-Type";
    @Metadata(description="The value of the HTTP header connection to use.", javaType="String")
    public static final String CONNECTION = HttpHeaderNames.CONNECTION.toString();
    @Metadata(description="Indicates whether the channel should be closed after complete.", javaType="Boolean")
    public static final String NETTY_CLOSE_CHANNEL_WHEN_COMPLETE = "CamelNettyCloseChannelWhenComplete";
    @Metadata(description="Allows to set the HTTP Status code to use. By default 200 is used for\nsuccess, and 500 for failure.", javaType="Integer")
    public static final String HTTP_RESPONSE_CODE = "CamelHttpResponseCode";
    @Metadata(description="The version of the HTTP protocol.", javaType="String", defaultValue="HTTP/1.1")
    public static final String HTTP_PROTOCOL_VERSION = "CamelHttpProtocolVersion";
    @Metadata(description="The HTTP method used, such as GET, POST, TRACE etc.", javaType="String", defaultValue="GET")
    public static final String HTTP_METHOD = "CamelHttpMethod";
    @Metadata(description="Any query parameters, such as `foo=bar&beer=yes`", javaType="String")
    public static final String HTTP_QUERY = "CamelHttpQuery";
    @Metadata(description="Allows to provide URI context-path and query parameters as a `String`\nvalue that overrides the endpoint configuration. This allows to reuse\nthe same producer for calling same remote http server, but using a\ndynamic context-path and query parameters.", javaType="String")
    public static final String HTTP_PATH = "CamelHttpPath";
    @Metadata(description="Any query parameters, such as `foo=bar&beer=yes`. Stored in the raw\nform, as they arrived to the consumer (i.e. before URL decoding).", javaType="String")
    public static final String HTTP_RAW_QUERY = "CamelHttpRawQuery";
    @Metadata(description="The URL including protocol, host and port, etc: \n`\\http://0.0.0.0:8080/myapp`.", javaType="String")
    public static final String HTTP_URL = "CamelHttpUrl";
    @Metadata(description="The charset from the content-type header.", javaType="String")
    public static final String HTTP_CHARACTER_ENCODING = "CamelHttpCharacterEncoding";
    @Metadata(description="The URI without protocol, host and port, etc:\n`/myapp`.", javaType="String")
    public static final String HTTP_URI = "CamelHttpUri";

    private NettyHttpConstants() {
    }
}

