/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.NettyEndpoint;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpEndpoint;
import org.apache.camel.util.ObjectHelper;

public class NettyHttpConsumer
extends NettyConsumer
implements Suspendable {
    public NettyHttpConsumer(NettyHttpEndpoint nettyEndpoint, Processor processor, NettyConfiguration configuration) {
        super((NettyEndpoint)nettyEndpoint, processor, configuration);
    }

    public NettyHttpEndpoint getEndpoint() {
        return (NettyHttpEndpoint)super.getEndpoint();
    }

    public NettyHttpConfiguration getConfiguration() {
        return (NettyHttpConfiguration)super.getConfiguration();
    }

    protected void doStart() throws Exception {
        super.doStart();
        ObjectHelper.notNull((Object)this.getNettyServerBootstrapFactory(), (String)"HttpServerBootstrapFactory", (Object)((Object)this));
        this.getNettyServerBootstrapFactory().addConsumer((NettyConsumer)this);
    }

    protected void doStop() throws Exception {
        this.getNettyServerBootstrapFactory().removeConsumer((NettyConsumer)this);
        super.doStop();
    }

    protected void doSuspend() throws Exception {
        if (!this.getConfiguration().isSend503whenSuspended()) {
            this.doStop();
        }
    }

    protected void doResume() throws Exception {
        if (!this.getConfiguration().isSend503whenSuspended()) {
            this.doStart();
        }
    }
}

