/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import java.io.IOException;
import java.security.Principal;
import java.util.Locale;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.camel.component.netty.http.HttpPrincipal;
import org.apache.camel.component.netty.http.SecurityAuthenticator;
import org.apache.camel.support.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecurityAuthenticatorSupport
implements SecurityAuthenticator {
    private String name;
    private String roleClassNames;

    protected SecurityAuthenticatorSupport() {
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setRoleClassNames(String roleClassNames) {
        this.roleClassNames = roleClassNames;
    }

    protected boolean isRoleClass(Principal principal) {
        if (this.roleClassNames == null) {
            return principal.getClass().getName().toLowerCase(Locale.US).contains("role");
        }
        for (String name : ObjectHelper.createIterable((String)this.roleClassNames)) {
            if (!principal.getClass().getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getUserRoles(Subject subject) {
        StringBuilder sb = new StringBuilder();
        for (Principal p : subject.getPrincipals()) {
            if (!this.isRoleClass(p)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(p.getName());
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public static final class HttpPrincipalCallbackHandler
    implements CallbackHandler {
        private static final Logger LOG = LoggerFactory.getLogger(HttpPrincipalCallbackHandler.class);
        private final HttpPrincipal principal;

        public HttpPrincipalCallbackHandler(HttpPrincipal principal) {
            this.principal = principal;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                LOG.trace("Callback {}", (Object)callback);
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    LOG.trace("Setting password on callback {}", (Object)pc);
                    pc.setPassword(this.principal.getPassword().toCharArray());
                    continue;
                }
                if (!(callback instanceof NameCallback)) continue;
                NameCallback nc = (NameCallback)callback;
                LOG.trace("Setting username on callback {}", (Object)nc);
                nc.setName(this.principal.getName());
            }
        }
    }
}

