/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import io.nats.client.Connection;
import io.nats.client.Message;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.nats.NatsConfiguration;
import org.apache.camel.component.nats.NatsEndpoint;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NatsProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(NatsProducer.class);
    private final ExecutorServiceManager executorServiceManager;
    private ScheduledExecutorService scheduler;
    private Connection connection;

    public NatsProducer(NatsEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.executorServiceManager = endpoint.getCamelContext().getExecutorServiceManager();
    }

    public NatsEndpoint getEndpoint() {
        return (NatsEndpoint)super.getEndpoint();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        NatsConfiguration config = this.getEndpoint().getConfiguration();
        byte[] body = (byte[])exchange.getIn().getBody(byte[].class);
        if (body == null) {
            try {
                body = ((String)exchange.getIn().getMandatoryBody(String.class)).getBytes();
            }
            catch (InvalidPayloadException e2) {
                exchange.setException((Throwable)e2);
                callback.done(true);
                return true;
            }
        }
        if (exchange.getPattern().isOutCapable()) {
            LOG.debug("Requesting to topic: {}", (Object)config.getTopic());
            CompletableFuture requestFuture = this.connection.request(config.getTopic(), body);
            CompletableFuture timeoutFuture = this.failAfter(exchange, Duration.ofMillis(config.getRequestTimeout()));
            CompletableFuture.anyOf(requestFuture, timeoutFuture).whenComplete((message, e) -> {
                if (e == null) {
                    Message msg = (Message)message;
                    exchange.getMessage().setBody((Object)msg.getData());
                    exchange.getMessage().setHeader("CamelNatsReplyTo", (Object)msg.getReplyTo());
                    exchange.getMessage().setHeader("CamelNatsSID", (Object)msg.getSID());
                    exchange.getMessage().setHeader("CamelNatsSubject", (Object)msg.getSubject());
                    exchange.getMessage().setHeader("CamelNatsQueueName", (Object)msg.getSubscription().getQueueName());
                    exchange.getMessage().setHeader("CamelNatsMessageTimestamp", (Object)System.currentTimeMillis());
                } else {
                    exchange.setException(e.getCause());
                }
                callback.done(false);
                if (!requestFuture.isDone()) {
                    requestFuture.cancel(true);
                }
                if (!timeoutFuture.isDone()) {
                    timeoutFuture.cancel(true);
                }
            });
            return false;
        }
        LOG.debug("Publishing to topic: {}", (Object)config.getTopic());
        if (ObjectHelper.isNotEmpty((Object)config.getReplySubject())) {
            String replySubject = config.getReplySubject();
            this.connection.publish(config.getTopic(), replySubject, body);
        } else {
            this.connection.publish(config.getTopic(), body);
        }
        callback.done(true);
        return true;
    }

    private <T> CompletableFuture<T> failAfter(Exchange exchange, Duration duration) {
        CompletableFuture future = new CompletableFuture();
        this.scheduler.schedule(() -> {
            ExchangeTimedOutException ex = new ExchangeTimedOutException(exchange, duration.toMillis());
            return future.completeExceptionally((Throwable)ex);
        }, duration.toNanos(), TimeUnit.NANOSECONDS);
        return future;
    }

    protected void doStart() throws Exception {
        ThreadPoolProfile profile = this.executorServiceManager.getThreadPoolProfile("CamelNatsRequestTimeoutExecutor");
        if (profile == null) {
            profile = this.executorServiceManager.getDefaultThreadPoolProfile();
        }
        this.scheduler = this.executorServiceManager.newScheduledThreadPool((Object)this, "CamelNatsRequestTimeoutExecutor", profile);
        super.doStart();
        LOG.debug("Starting Nats Producer");
        LOG.debug("Getting Nats Connection");
        this.connection = this.getEndpoint().getConfiguration().getConnection() != null ? this.getEndpoint().getConfiguration().getConnection() : this.getEndpoint().getConnection();
    }

    protected void doStop() throws Exception {
        if (this.scheduler != null) {
            this.executorServiceManager.shutdownNow((ExecutorService)this.scheduler);
        }
        LOG.debug("Stopping Nats Producer");
        if (ObjectHelper.isEmpty((Object)this.getEndpoint().getConfiguration().getConnection())) {
            LOG.debug("Closing Nats Connection");
            if (this.connection != null && !this.connection.getStatus().equals((Object)Connection.Status.CLOSED)) {
                if (this.getEndpoint().getConfiguration().isFlushConnection()) {
                    LOG.debug("Flushing Nats Connection");
                    this.connection.flush(Duration.ofMillis(this.getEndpoint().getConfiguration().getFlushTimeout()));
                }
                this.connection.close();
            }
        }
        super.doStop();
    }
}

