/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import io.nats.client.Connection;
import io.nats.client.Nats;
import io.nats.client.Options;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.nats.NatsComponent;
import org.apache.camel.component.nats.NatsConfiguration;
import org.apache.camel.component.nats.NatsConsumer;
import org.apache.camel.component.nats.NatsProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.17.0", scheme="nats", title="Nats", syntax="nats:topic", category={Category.MESSAGING})
public class NatsEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport {
    @UriParam
    private NatsConfiguration configuration;

    public NatsEndpoint(String uri, NatsComponent component, NatsConfiguration config) {
        super(uri, (Component)component);
        this.configuration = config;
    }

    public Producer createProducer() throws Exception {
        return new NatsProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        NatsConsumer consumer = new NatsConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    public ExecutorService createExecutor() {
        return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "NatsTopic[" + this.configuration.getTopic() + "]", this.configuration.getPoolSize());
    }

    public NatsConfiguration getConfiguration() {
        return this.configuration;
    }

    public Connection getConnection() throws InterruptedException, IllegalArgumentException, GeneralSecurityException, IOException {
        Options.Builder builder = this.getConfiguration().createOptions();
        if (this.getConfiguration().getSslContextParameters() != null && this.getConfiguration().isSecure()) {
            SSLContext sslCtx = this.getConfiguration().getSslContextParameters().createSSLContext(this.getCamelContext());
            builder.sslContext(sslCtx);
        }
        Options options = builder.build();
        return Nats.connect((Options)options);
    }
}

