/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nagios;

import com.googlecode.jsendnsca.Level;
import com.googlecode.jsendnsca.MessagePayload;
import com.googlecode.jsendnsca.NagiosPassiveCheckSender;
import com.googlecode.jsendnsca.NagiosSettings;
import com.googlecode.jsendnsca.PassiveCheckSender;
import org.apache.camel.component.nagios.NagiosConfiguration;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NagiosEventNotifier
extends EventNotifierSupport {
    private static final Logger LOG = LoggerFactory.getLogger(NagiosEventNotifier.class);
    private NagiosSettings nagiosSettings;
    private NagiosConfiguration configuration;
    private PassiveCheckSender sender;
    private String serviceName = "Camel";
    private String hostName = "localhost";

    public NagiosEventNotifier() {
    }

    public NagiosEventNotifier(PassiveCheckSender sender) {
        this.sender = sender;
    }

    public void notify(CamelEvent eventObject) throws Exception {
        String message = eventObject.toString();
        Level level = this.determineLevel(eventObject);
        MessagePayload payload = new MessagePayload(this.getHostName(), level, this.getServiceName(), message);
        if (LOG.isInfoEnabled()) {
            LOG.info("Sending notification to Nagios: {}", (Object)payload.getMessage());
        }
        this.sender.send(payload);
        LOG.trace("Sending notification done");
    }

    public boolean isEnabled(CamelEvent eventObject) {
        return true;
    }

    protected Level determineLevel(CamelEvent eventObject) {
        if (eventObject instanceof CamelEvent.ExchangeFailedEvent || eventObject instanceof CamelEvent.CamelContextStartupFailureEvent || eventObject instanceof CamelEvent.CamelContextStopFailureEvent || eventObject instanceof CamelEvent.ServiceStartupFailureEvent || eventObject instanceof CamelEvent.ServiceStopFailureEvent) {
            return Level.CRITICAL;
        }
        if (eventObject instanceof CamelEvent.ExchangeFailureHandledEvent || eventObject instanceof CamelEvent.ExchangeRedeliveryEvent) {
            return Level.WARNING;
        }
        return Level.OK;
    }

    public NagiosConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new NagiosConfiguration();
        }
        return this.configuration;
    }

    public void setConfiguration(NagiosConfiguration configuration) {
        this.configuration = configuration;
    }

    public NagiosSettings getNagiosSettings() {
        return this.nagiosSettings;
    }

    public void setNagiosSettings(NagiosSettings nagiosSettings) {
        this.nagiosSettings = nagiosSettings;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    protected void doStart() throws Exception {
        if (this.nagiosSettings == null) {
            this.nagiosSettings = this.configuration.getOrCreateNagiosSettings();
        }
        if (this.sender == null) {
            this.sender = new NagiosPassiveCheckSender(this.nagiosSettings);
        }
        LOG.info("Using {}", (Object)this.configuration);
    }

    protected void doStop() throws Exception {
        this.sender = null;
    }
}

