/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mqtt;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.mqtt.MQTTEndpoint;
import org.apache.camel.impl.DefaultConsumer;

public class MQTTConsumer
extends DefaultConsumer {
    public MQTTConsumer(MQTTEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public MQTTEndpoint getEndpoint() {
        return (MQTTEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        this.getEndpoint().addConsumer(this);
        if (!this.getEndpoint().isConnected()) {
            this.getEndpoint().connect();
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.getEndpoint().removeConsumer(this);
        super.doStop();
    }

    void processExchange(final Exchange exchange) {
        boolean sync = true;
        try {
            sync = this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    if (exchange.getException() != null) {
                        MQTTConsumer.this.getExceptionHandler().handleException("Error processing exchange.", exchange, (Throwable)exchange.getException());
                    }
                }
            });
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        if (sync && exchange.getException() != null) {
            this.getExceptionHandler().handleException("Error processing exchange.", exchange, (Throwable)exchange.getException());
        }
    }
}

