/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb3;

import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.mongodb3.MongoDbEndpoint;
import org.apache.camel.component.mongodb3.MongoDbTailTrackingManager;
import org.apache.camel.component.mongodb3.MongoDbTailingThread;
import org.apache.camel.impl.DefaultConsumer;

public class MongoDbTailableCursorConsumer
extends DefaultConsumer {
    private final MongoDbEndpoint endpoint;
    private ExecutorService executor;
    private MongoDbTailingThread tailingThread;

    public MongoDbTailableCursorConsumer(MongoDbEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.tailingThread != null) {
            this.tailingThread.stop();
        }
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.executor);
            this.executor = null;
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.endpoint.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, this.endpoint.getEndpointUri(), 1);
        MongoDbTailTrackingManager trackingManager = this.initTailTracking();
        this.tailingThread = new MongoDbTailingThread(this.endpoint, this, trackingManager);
        this.tailingThread.init();
        this.executor.execute(this.tailingThread);
    }

    protected MongoDbTailTrackingManager initTailTracking() throws Exception {
        MongoDbTailTrackingManager answer = new MongoDbTailTrackingManager(this.endpoint.getMongoConnection(), this.endpoint.getTailTrackingConfig());
        answer.initialize();
        return answer;
    }
}

