/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class MinaEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":protocol:host:port";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "mina".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "protocol", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "port", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(30);
        props.add("allowDefaultCodec");
        props.add("bridgeErrorHandler");
        props.add("cachedAddress");
        props.add("clientMode");
        props.add("codec");
        props.add("decoderMaxLineLength");
        props.add("disconnect");
        props.add("disconnectOnNoReply");
        props.add("encoderMaxLineLength");
        props.add("encoding");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("filters");
        props.add("host");
        props.add("lazySessionCreation");
        props.add("lazyStartProducer");
        props.add("maximumPoolSize");
        props.add("minaLogger");
        props.add("noReplyLogLevel");
        props.add("objectCodecPattern");
        props.add("orderedThreadPoolExecutor");
        props.add("port");
        props.add("protocol");
        props.add("sslContextParameters");
        props.add("sync");
        props.add("textline");
        props.add("textlineDelimiter");
        props.add("timeout");
        props.add("transferExchange");
        props.add("writeTimeout");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

