/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.component.mina.MinaConfiguration;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.component.mina.MinaHelper;
import org.apache.camel.component.mina.MinaPayloadHelper;
import org.apache.camel.component.mina.MinaTextLineCodecFactory;
import org.apache.camel.component.mina.MinaTextLineDelimiter;
import org.apache.camel.component.mina.MinaUdpProtocolCodecFactory;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import org.apache.mina.filter.codec.textline.LineDelimiter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.filter.executor.OrderedThreadPoolExecutor;
import org.apache.mina.filter.executor.UnorderedThreadPoolExecutor;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioDatagramConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MinaProducer.class);
    private final ResponseHandler handler;
    private IoSession session;
    private CountDownLatch responseLatch;
    private CountDownLatch closeLatch;
    private boolean lazySessionCreation;
    private long writeTimeout;
    private long timeout;
    private SocketAddress address;
    private IoConnector connector;
    private boolean sync;
    private CamelLogger noReplyLogger;
    private MinaConfiguration configuration;
    private IoSessionConfig connectorConfig;
    private ExecutorService workerPool;

    public MinaProducer(MinaEndpoint endpoint) throws Exception {
        super((Endpoint)endpoint);
        this.configuration = endpoint.getConfiguration();
        this.lazySessionCreation = this.configuration.isLazySessionCreation();
        this.writeTimeout = this.configuration.getWriteTimeout();
        this.timeout = this.configuration.getTimeout();
        this.sync = this.configuration.isSync();
        this.noReplyLogger = new CamelLogger(LOG, this.configuration.getNoReplyLogLevel());
        String protocol = this.configuration.getProtocol();
        if (protocol.equals("tcp")) {
            this.setupSocketProtocol();
        } else if (this.configuration.isDatagramProtocol()) {
            this.setupDatagramProtocol();
        } else if (protocol.equals("vm")) {
            this.setupVmProtocol();
        }
        this.handler = new ResponseHandler();
        this.connector.setHandler((IoHandler)this.handler);
    }

    public MinaEndpoint getEndpoint() {
        return (MinaEndpoint)super.getEndpoint();
    }

    public boolean isSingleton() {
        return !this.sync;
    }

    public void process(Exchange exchange) throws Exception {
        try {
            this.doProcess(exchange);
        }
        finally {
            this.maybeDisconnectOnDone(exchange);
        }
    }

    protected void doProcess(Exchange exchange) throws Exception {
        Object body;
        if (this.session == null && !this.lazySessionCreation) {
            throw new IllegalStateException("Not started yet!");
        }
        if (this.session == null || !this.session.isConnected()) {
            this.openConnection();
        }
        if (this.getEndpoint().getConfiguration().getCharsetName() != null) {
            exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)IOHelper.normalizeCharset((String)this.getEndpoint().getConfiguration().getCharsetName()));
        }
        if ((body = MinaPayloadHelper.getIn(this.getEndpoint(), exchange)) == null) {
            this.noReplyLogger.log("No payload to send for exchange: " + exchange);
            return;
        }
        if (this.getEndpoint().getConfiguration().isTextline()) {
            body = this.getEndpoint().getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, body);
        }
        if (this.sync) {
            this.responseLatch = new CountDownLatch(1);
            this.handler.reset();
        }
        if (LOG.isDebugEnabled()) {
            Object out = body;
            if (body instanceof byte[]) {
                out = exchange.getContext().getTypeConverter().convertTo(String.class, body);
            }
            LOG.debug("Writing body: {}", out);
        }
        MinaHelper.writeBody(this.session, body, exchange, this.writeTimeout);
        if (this.sync) {
            LOG.debug("Waiting for response using timeout {} millis.", (Object)this.timeout);
            boolean done = this.responseLatch.await(this.timeout, TimeUnit.MILLISECONDS);
            if (!done) {
                this.maybeDisconnectOnTimeout();
                throw new ExchangeTimedOutException(exchange, this.timeout);
            }
            if (this.handler.getCause() != null) {
                throw new CamelExchangeException("Error occurred in ResponseHandler", exchange, this.handler.getCause());
            }
            if (!this.handler.isMessageReceived()) {
                this.maybeDisconnectOnTimeout();
                throw new ExchangeTimedOutException(exchange, this.timeout);
            }
            if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
                MinaPayloadHelper.setOut(exchange, this.handler.getMessage());
            } else {
                MinaPayloadHelper.setIn(exchange, this.handler.getMessage());
            }
        }
    }

    protected void maybeDisconnectOnTimeout() throws InterruptedException {
        if (this.session == null) {
            return;
        }
        if (this.configuration.isDisconnectOnNoReply()) {
            LOG.debug("Closing session when timed out at address: {}", (Object)this.address);
            this.closeSessionIfNeededAndAwaitCloseInHandler(this.session);
        }
    }

    protected void maybeDisconnectOnDone(Exchange exchange) throws InterruptedException {
        if (this.session == null) {
            return;
        }
        Boolean close = ExchangeHelper.isOutCapable((Exchange)exchange) ? (Boolean)exchange.getOut().getHeader("CamelMinaCloseSessionWhenComplete", Boolean.class) : (Boolean)exchange.getIn().getHeader("CamelMinaCloseSessionWhenComplete", Boolean.class);
        boolean disconnect = this.getEndpoint().getConfiguration().isDisconnect();
        if (close != null) {
            disconnect = close;
        }
        if (disconnect) {
            LOG.debug("Closing session when complete at address: {}", (Object)this.address);
            this.closeSessionIfNeededAndAwaitCloseInHandler(this.session);
        }
    }

    private void closeSessionIfNeededAndAwaitCloseInHandler(IoSession sessionToBeClosed) throws InterruptedException {
        this.closeLatch = new CountDownLatch(1);
        if (!sessionToBeClosed.isClosing()) {
            CloseFuture closeFuture = sessionToBeClosed.closeNow();
            closeFuture.await(this.timeout, TimeUnit.MILLISECONDS);
            this.closeLatch.await(this.timeout, TimeUnit.MILLISECONDS);
        }
    }

    public DefaultIoFilterChainBuilder getFilterChain() {
        return this.connector.getFilterChain();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!this.lazySessionCreation) {
            this.openConnection();
        }
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping connector: {} at address: {}", (Object)this.connector, (Object)this.address);
        }
        this.closeConnection();
        super.doStop();
    }

    protected void doShutdown() throws Exception {
        if (this.workerPool != null) {
            this.workerPool.shutdown();
        }
        super.doShutdown();
    }

    private void closeConnection() throws InterruptedException {
        if (this.session != null) {
            this.closeSessionIfNeededAndAwaitCloseInHandler(this.session);
        }
        this.connector.dispose(true);
    }

    private void openConnection() {
        if (this.address == null || !this.configuration.isCachedAddress()) {
            this.setSocketAddress(this.configuration.getProtocol());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating connector to address: {} using connector: {} timeout: {} millis.", new Object[]{this.address, this.connector, this.timeout});
        }
        if (this.connectorConfig != null) {
            this.connector.getSessionConfig().setAll(this.connectorConfig);
        }
        ConnectFuture future = this.connector.connect(this.address);
        future.awaitUninterruptibly();
        this.session = future.getSession();
    }

    protected void setupVmProtocol() {
        boolean minaLogger = this.configuration.isMinaLogger();
        List<IoFilter> filters = this.configuration.getFilters();
        this.address = new VmPipeAddress(this.configuration.getPort());
        this.connector = new VmPipeConnector();
        if (minaLogger) {
            this.connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.appendIoFiltersToChain(filters, this.connector.getFilterChain());
        if (this.configuration.getSslContextParameters() != null) {
            LOG.warn("Using vm protocol, but an SSLContextParameters instance was provided.  SSLContextParameters is only supported on the TCP protocol.");
        }
        this.configureCodecFactory("MinaProducer", (IoService)this.connector);
    }

    protected void setupSocketProtocol() throws Exception {
        boolean minaLogger = this.configuration.isMinaLogger();
        long timeout = this.configuration.getTimeout();
        List<IoFilter> filters = this.configuration.getFilters();
        this.address = new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort());
        int processorCount = Runtime.getRuntime().availableProcessors() + 1;
        this.connector = new NioSocketConnector(processorCount);
        this.connectorConfig = this.connector.getSessionConfig();
        this.workerPool = this.configuration.isOrderedThreadPoolExecutor() ? new OrderedThreadPoolExecutor(this.configuration.getMaximumPoolSize()) : new UnorderedThreadPoolExecutor(this.configuration.getMaximumPoolSize());
        this.connector.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)this.workerPool));
        if (minaLogger) {
            this.connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.appendIoFiltersToChain(filters, this.connector.getFilterChain());
        if (this.configuration.getSslContextParameters() != null) {
            SslFilter filter = new SslFilter(this.configuration.getSslContextParameters().createSSLContext(this.getEndpoint().getCamelContext()), this.configuration.isAutoStartTls());
            filter.setUseClientMode(true);
            this.connector.getFilterChain().addFirst("sslFilter", (IoFilter)filter);
        }
        this.configureCodecFactory("MinaProducer", (IoService)this.connector);
        this.connector.setConnectTimeoutMillis(timeout);
    }

    protected void configureCodecFactory(String type, IoService service) {
        if (this.configuration.getCodec() != null) {
            this.addCodecFactory(service, this.configuration.getCodec());
        } else if (this.configuration.isAllowDefaultCodec()) {
            this.configureDefaultCodecFactory(type, service);
        }
    }

    protected void configureDefaultCodecFactory(String type, IoService service) {
        if (this.configuration.isTextline()) {
            Charset charset = this.getEncodingParameter(type, this.configuration);
            LineDelimiter delimiter = MinaProducer.getLineDelimiterParameter(this.configuration.getTextlineDelimiter());
            MinaTextLineCodecFactory codecFactory = new MinaTextLineCodecFactory(charset, delimiter);
            if (this.configuration.getEncoderMaxLineLength() > 0) {
                codecFactory.setEncoderMaxLineLength(this.configuration.getEncoderMaxLineLength());
            }
            if (this.configuration.getDecoderMaxLineLength() > 0) {
                codecFactory.setDecoderMaxLineLength(this.configuration.getDecoderMaxLineLength());
            }
            this.addCodecFactory(service, codecFactory);
            LOG.debug("{}: Using TextLineCodecFactory: {} using encoding: {} line delimiter: {}({})", new Object[]{type, codecFactory, charset, this.configuration.getTextlineDelimiter(), delimiter});
            LOG.debug("Encoder maximum line length: {}. Decoder maximum line length: {}", (Object)codecFactory.getEncoderMaxLineLength(), (Object)codecFactory.getDecoderMaxLineLength());
        } else {
            ObjectSerializationCodecFactory codecFactory = new ObjectSerializationCodecFactory();
            this.addCodecFactory(service, (ProtocolCodecFactory)codecFactory);
            LOG.debug("{}: Using ObjectSerializationCodecFactory: {}", (Object)type, (Object)codecFactory);
        }
    }

    protected void setupDatagramProtocol() {
        boolean minaLogger = this.configuration.isMinaLogger();
        boolean transferExchange = this.configuration.isTransferExchange();
        List<IoFilter> filters = this.configuration.getFilters();
        if (transferExchange) {
            throw new IllegalArgumentException("transferExchange=true is not supported for datagram protocol");
        }
        this.address = new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort());
        int processorCount = Runtime.getRuntime().availableProcessors() + 1;
        this.connector = new NioDatagramConnector(processorCount);
        this.workerPool = this.configuration.isOrderedThreadPoolExecutor() ? new OrderedThreadPoolExecutor(this.configuration.getMaximumPoolSize()) : new UnorderedThreadPoolExecutor(this.configuration.getMaximumPoolSize());
        this.connectorConfig = this.connector.getSessionConfig();
        this.connector.getFilterChain().addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)this.workerPool));
        if (minaLogger) {
            this.connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        }
        this.appendIoFiltersToChain(filters, this.connector.getFilterChain());
        if (this.configuration.getSslContextParameters() != null) {
            LOG.warn("Using datagram protocol, {}, but an SSLContextParameters instance was provided. SSLContextParameters is only supported on the TCP protocol.", (Object)this.configuration.getProtocol());
        }
        this.configureDataGramCodecFactory("MinaProducer", (IoService)this.connector, this.configuration);
        this.connector.setConnectTimeoutMillis(this.timeout);
    }

    protected void configureDataGramCodecFactory(String type, IoService service, MinaConfiguration configuration) {
        ProtocolCodecFactory codecFactory = configuration.getCodec();
        if (codecFactory == null) {
            codecFactory = new MinaUdpProtocolCodecFactory(this.getEndpoint().getCamelContext());
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: Using CodecFactory: {}", (Object)type, (Object)codecFactory);
            }
        }
        this.addCodecFactory(service, codecFactory);
    }

    private void addCodecFactory(IoService service, ProtocolCodecFactory codecFactory) {
        LOG.debug("addCodecFactory name: {}", (Object)codecFactory.getClass().getName());
        service.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter(codecFactory));
    }

    private static LineDelimiter getLineDelimiterParameter(MinaTextLineDelimiter delimiter) {
        if (delimiter == null) {
            return LineDelimiter.DEFAULT;
        }
        return delimiter.getLineDelimiter();
    }

    private Charset getEncodingParameter(String type, MinaConfiguration configuration) {
        String encoding = configuration.getEncoding();
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
            configuration.setEncoding(encoding);
            LOG.debug("{}: No encoding parameter using default charset: {}", (Object)type, (Object)encoding);
        }
        if (!Charset.isSupported(encoding)) {
            throw new IllegalArgumentException("The encoding: " + encoding + " is not supported");
        }
        return Charset.forName(encoding);
    }

    private void appendIoFiltersToChain(List<IoFilter> filters, DefaultIoFilterChainBuilder filterChain) {
        if (filters != null && !filters.isEmpty()) {
            for (IoFilter ioFilter : filters) {
                filterChain.addLast(ioFilter.getClass().getCanonicalName(), ioFilter);
            }
        }
    }

    private void setSocketAddress(String protocol) {
        if (protocol.equals("tcp")) {
            this.address = new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort());
        } else if (this.configuration.isDatagramProtocol()) {
            this.address = new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort());
        } else if (protocol.equals("vm")) {
            this.address = new VmPipeAddress(this.configuration.getPort());
        }
    }

    private final class ResponseHandler
    extends IoHandlerAdapter {
        private Object message;
        private Throwable cause;
        private boolean messageReceived;

        private ResponseHandler() {
        }

        public void reset() {
            this.message = null;
            this.cause = null;
            this.messageReceived = false;
        }

        public void messageReceived(IoSession ioSession, Object message) throws Exception {
            LOG.debug("Message received: {}", message);
            this.message = message;
            this.messageReceived = true;
            this.cause = null;
            this.notifyResultAvailable();
        }

        protected void notifyResultAvailable() {
            CountDownLatch downLatch = MinaProducer.this.responseLatch;
            if (downLatch != null) {
                downLatch.countDown();
            }
        }

        public void sessionClosed(IoSession session) throws Exception {
            if (MinaProducer.this.sync && !this.messageReceived) {
                LOG.debug("Session closed but no message received from address: {}", (Object)MinaProducer.this.address);
                this.notifyResultAvailable();
            }
            this.notifySessionClosed();
        }

        private void notifySessionClosed() {
            if (MinaProducer.this.closeLatch != null) {
                MinaProducer.this.closeLatch.countDown();
            }
        }

        public void exceptionCaught(IoSession ioSession, Throwable cause) {
            this.message = null;
            this.messageReceived = false;
            this.cause = cause;
            if (ioSession != null && !this.closedByMina(cause)) {
                CloseFuture closeFuture = ioSession.closeNow();
                closeFuture.awaitUninterruptibly(MinaProducer.this.timeout, TimeUnit.MILLISECONDS);
            }
        }

        private boolean closedByMina(Throwable cause) {
            return cause instanceof IOException;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public Object getMessage() {
            return this.message;
        }

        public boolean isMessageReceived() {
            return this.messageReceived;
        }
    }
}

