/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.server;

import java.util.function.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.milo.Messages;
import org.apache.camel.component.milo.server.MiloServerEndpoint;
import org.apache.camel.component.milo.server.internal.CamelServerItem;
import org.apache.camel.support.DefaultConsumer;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;

public class MiloServerConsumer
extends DefaultConsumer {
    private final Consumer<DataValue> writeHandler = this::performWrite;
    private CamelServerItem item;

    public MiloServerConsumer(MiloServerEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public MiloServerEndpoint getEndpoint() {
        return (MiloServerEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.item = this.getEndpoint().getItem();
        this.item.addWriteListener(this.writeHandler);
    }

    protected void doStop() throws Exception {
        this.item.removeWriteListener(this.writeHandler);
        super.doStop();
    }

    protected void performWrite(DataValue value) {
        Exchange exchange = this.createExchange(true);
        try {
            this.mapToMessage(value, exchange.getMessage());
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error processing exchange", (Throwable)e);
        }
    }

    private void mapToMessage(DataValue value, Message message) {
        if (value != null) {
            Messages.fillFromDataValue(value, message);
        }
    }
}

