/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.browse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.milo.browse.MiloBrowseEndpoint;
import org.apache.camel.component.milo.client.MiloClientConnection;
import org.apache.camel.support.DefaultAsyncProducer;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiloBrowseProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MiloBrowseProducer.class);
    private MiloClientConnection connection;

    public MiloBrowseProducer(MiloBrowseEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public MiloBrowseEndpoint getEndpoint() {
        return (MiloBrowseEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.connection = this.getEndpoint().createConnection();
    }

    protected void doStop() throws Exception {
        if (null != this.connection) {
            this.getEndpoint().releaseConnection(this.connection);
        }
        super.doStop();
    }

    private ExpandedNodeId tryParse(String nodeString) {
        Optional nodeId = NodeId.parseSafe((String)nodeString);
        return nodeId.map(NodeId::expanded).orElseGet(() -> ExpandedNodeId.parse((String)nodeString));
    }

    public boolean process(Exchange exchange, AsyncCallback async) {
        Message message = exchange.getMessage();
        ArrayList<ExpandedNodeId> expandedNodeIds = new ArrayList<ExpandedNodeId>();
        if (message.getHeaders().containsKey("CamelMiloNodeIds")) {
            List nodes = (List)message.getHeader("CamelMiloNodeIds", Collections.singletonList(this.getEndpoint().getNode()), List.class);
            message.removeHeader("CamelMiloNodeIds");
            if (null == nodes) {
                LOG.warn("Browse nodes: No node ids specified");
                async.done(true);
                return true;
            }
            for (Object node : nodes) {
                expandedNodeIds.add(this.tryParse(node.toString()));
            }
        } else {
            expandedNodeIds.add(this.tryParse(this.getEndpoint().getNode()));
        }
        MiloBrowseEndpoint endpoint = this.getEndpoint();
        int depth = endpoint.isRecursive() ? endpoint.getDepth() : -1;
        boolean subTypes = endpoint.isIncludeSubTypes() || endpoint.isRecursive();
        CompletionStage future = ((CompletableFuture)this.connection.browse(expandedNodeIds, endpoint.getDirection(), endpoint.getNodeClassMask(), depth, endpoint.getFilter(), subTypes, endpoint.getMaxNodeIdsPerRequest()).thenApply(browseResults -> {
            List expandedNodes = browseResults.values().stream().map(BrowseResult::getReferences).flatMap(Stream::of).map(ReferenceDescription::getNodeId).map(ExpandedNodeId::toParseableString).collect(Collectors.toList());
            exchange.getMessage().setHeader("CamelMiloNodeIds", expandedNodes);
            exchange.getMessage().setBody(browseResults);
            return browseResults;
        })).whenComplete((actual, error) -> {
            String expandedNodeIdsString = expandedNodeIds.stream().map(ExpandedNodeId::toParseableString).collect(Collectors.joining(", "));
            if (actual != null) {
                LOG.debug("Browse node(s) {} -> {} result(s)", (Object)expandedNodeIdsString, (Object)actual.size());
            } else {
                LOG.error("Browse node(s) {} -> failed: {}", (Object)expandedNodeIdsString, (Object)error.getMessage());
                exchange.setException(error);
            }
            async.done(false);
        });
        return false;
    }
}

