/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.browse;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.milo.browse.MiloBrowseEndpoint;
import org.apache.camel.component.milo.client.MiloClientCachingConnectionManager;
import org.apache.camel.component.milo.client.MiloClientConfiguration;
import org.apache.camel.component.milo.client.MiloClientConnectionManager;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="milo-browse")
public class MiloBrowseComponent
extends DefaultComponent {
    @Metadata
    private MiloClientConfiguration configuration = new MiloClientConfiguration();
    @Metadata(autowired=true, label="client", description="Instance for managing client connections")
    private MiloClientConnectionManager miloClientConnectionManager = new MiloClientCachingConnectionManager();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MiloClientConfiguration browseConfiguration = new MiloClientConfiguration(this.getConfiguration());
        browseConfiguration.setEndpointUri(remaining);
        MiloBrowseEndpoint endpoint = new MiloBrowseEndpoint(uri, this, browseConfiguration.getEndpointUri(), this.getMiloClientConnectionManager());
        endpoint.setConfiguration(browseConfiguration);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public MiloClientConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MiloClientConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setApplicationName(String applicationName) {
        this.configuration.setApplicationName(applicationName);
    }

    public void setApplicationUri(String applicationUri) {
        this.configuration.setApplicationUri(applicationUri);
    }

    public void setProductUri(String productUri) {
        this.configuration.setProductUri(productUri);
    }

    public void setReconnectTimeout(Long reconnectTimeout) {
        this.configuration.setRequestTimeout(reconnectTimeout);
    }

    public MiloClientConnectionManager getMiloClientConnectionManager() {
        return this.miloClientConnectionManager;
    }

    public void setMiloClientConnectionManager(MiloClientConnectionManager miloClientConnectionManager) {
        this.miloClientConnectionManager = miloClientConnectionManager;
    }
}

