/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.server;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.milo.KeyStoreLoader;
import org.apache.camel.component.milo.client.MiloClientConsumer;
import org.apache.camel.component.milo.server.MiloServerEndpoint;
import org.apache.camel.component.milo.server.internal.CamelNamespace;
import org.apache.camel.impl.DefaultComponent;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfig;
import org.eclipse.milo.opcua.sdk.server.api.config.OpcUaServerConfigBuilder;
import org.eclipse.milo.opcua.sdk.server.identity.AnonymousIdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.IdentityValidator;
import org.eclipse.milo.opcua.sdk.server.identity.UsernameIdentityValidator;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.application.CertificateManager;
import org.eclipse.milo.opcua.stack.core.application.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.application.DefaultCertificateManager;
import org.eclipse.milo.opcua.stack.core.application.DefaultCertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.UserTokenType;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiloServerComponent
extends DefaultComponent {
    public static final String DEFAULT_NAMESPACE_URI = "urn:org:apache:camel";
    private static final Logger LOG = LoggerFactory.getLogger(MiloClientConsumer.class);
    private static final String URL_CHARSET = "UTF-8";
    private static final OpcUaServerConfig DEFAULT_SERVER_CONFIG;
    private String namespaceUri = "urn:org:apache:camel";
    private final OpcUaServerConfigBuilder serverConfig;
    private OpcUaServer server;
    private CamelNamespace namespace;
    private final Map<String, MiloServerEndpoint> endpoints = new HashMap<String, MiloServerEndpoint>();
    private Boolean enableAnonymousAuthentication;
    private Map<String, String> userMap;
    private String usernameSecurityPolicyUri = OpcUaServerConfig.USER_TOKEN_POLICY_USERNAME.getSecurityPolicyUri();
    private List<String> bindAddresses;
    private Supplier<CertificateValidator> certificateValidator;
    private final List<Runnable> runOnStop = new LinkedList<Runnable>();

    public MiloServerComponent() {
        this(DEFAULT_SERVER_CONFIG);
    }

    public MiloServerComponent(OpcUaServerConfig serverConfig) {
        this.serverConfig = OpcUaServerConfig.copy((OpcUaServerConfig)(serverConfig != null ? serverConfig : DEFAULT_SERVER_CONFIG));
    }

    protected void doStart() throws Exception {
        this.server = new OpcUaServer(this.buildServerConfig());
        this.namespace = (CamelNamespace)this.server.getNamespaceManager().registerAndAdd(this.namespaceUri, index -> new CamelNamespace((UShort)index, this.namespaceUri, this.server));
        super.doStart();
        this.server.startup();
    }

    private OpcUaServerConfig buildServerConfig() {
        if (this.userMap != null || this.enableAnonymousAuthentication != null) {
            HashMap<String, String> userMap = this.userMap != null ? new HashMap<String, String>(this.userMap) : Collections.emptyMap();
            boolean allowAnonymous = Boolean.TRUE.equals(this.enableAnonymousAuthentication);
            UsernameIdentityValidator identityValidator = new UsernameIdentityValidator(allowAnonymous, challenge -> {
                String pwd = (String)userMap.get(challenge.getUsername());
                if (pwd == null) {
                    return false;
                }
                return pwd.equals(challenge.getPassword());
            });
            this.serverConfig.setIdentityValidator((IdentityValidator)identityValidator);
            LinkedList<UserTokenPolicy> tokenPolicies = new LinkedList<UserTokenPolicy>();
            if (allowAnonymous) {
                tokenPolicies.add(OpcUaServerConfig.USER_TOKEN_POLICY_ANONYMOUS);
            }
            if (userMap != null) {
                tokenPolicies.add(this.getUsernamePolicy());
            }
            this.serverConfig.setUserTokenPolicies(tokenPolicies);
        }
        if (this.bindAddresses != null) {
            this.serverConfig.setBindAddresses(new ArrayList<String>(this.bindAddresses));
        }
        if (this.certificateValidator != null) {
            CertificateValidator validator = this.certificateValidator.get();
            LOG.debug("Using validator: {}", (Object)validator);
            if (validator instanceof Closeable) {
                this.runOnStop(() -> {
                    try {
                        LOG.debug("Closing: {}", (Object)validator);
                        ((Closeable)validator).close();
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to close", (Throwable)e);
                    }
                });
            }
            this.serverConfig.setCertificateValidator(validator);
        }
        return this.serverConfig.build();
    }

    private UserTokenPolicy getUsernamePolicy() {
        if (this.usernameSecurityPolicyUri == null || this.usernameSecurityPolicyUri.isEmpty()) {
            return OpcUaServerConfig.USER_TOKEN_POLICY_USERNAME;
        }
        return new UserTokenPolicy("username", UserTokenType.UserName, null, null, this.usernameSecurityPolicyUri);
    }

    private void runOnStop(Runnable runnable) {
        this.runOnStop.add(runnable);
    }

    protected void doStop() throws Exception {
        this.server.shutdown();
        super.doStop();
        this.runOnStop.forEach(runnable -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOG.warn("Failed to run on stop", (Throwable)e);
            }
        });
        this.runOnStop.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MiloServerComponent miloServerComponent = this;
        synchronized (miloServerComponent) {
            if (remaining == null || remaining.isEmpty()) {
                return null;
            }
            MiloServerEndpoint endpoint = this.endpoints.get(remaining);
            if (endpoint == null) {
                endpoint = new MiloServerEndpoint(uri, remaining, this.namespace, (Component)this);
                this.setProperties((Object)endpoint, parameters);
                this.endpoints.put(remaining, endpoint);
            }
            return endpoint;
        }
    }

    public void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    public void setApplicationName(String applicationName) {
        Objects.requireNonNull(applicationName);
        this.serverConfig.setApplicationName(LocalizedText.english((String)applicationName));
    }

    public void setApplicationUri(String applicationUri) {
        Objects.requireNonNull(applicationUri);
        this.serverConfig.setApplicationUri(applicationUri);
    }

    public void setProductUri(String productUri) {
        Objects.requireNonNull(productUri);
        this.serverConfig.setProductUri(productUri);
    }

    public void setBindPort(int port) {
        this.serverConfig.setBindPort(port);
    }

    public void setStrictEndpointUrlsEnabled(boolean strictEndpointUrlsEnforced) {
        this.serverConfig.setStrictEndpointUrlsEnabled(strictEndpointUrlsEnforced);
    }

    public void setServerName(String serverName) {
        this.serverConfig.setServerName(serverName);
    }

    public void setHostname(String hostname) {
        this.serverConfig.setServerName(hostname);
    }

    public void setSecurityPolicies(Set<SecurityPolicy> securityPolicies) {
        if (securityPolicies == null || securityPolicies.isEmpty()) {
            this.serverConfig.setSecurityPolicies(EnumSet.noneOf(SecurityPolicy.class));
        } else {
            this.serverConfig.setSecurityPolicies(EnumSet.copyOf(securityPolicies));
        }
    }

    public void setSecurityPoliciesById(Collection<String> securityPolicies) {
        EnumSet<SecurityPolicy> policies = EnumSet.noneOf(SecurityPolicy.class);
        if (securityPolicies != null) {
            for (String policyName : securityPolicies) {
                SecurityPolicy policy = SecurityPolicy.fromUriSafe((String)policyName).orElseGet(() -> SecurityPolicy.valueOf((String)policyName));
                policies.add(policy);
            }
        }
        this.serverConfig.setSecurityPolicies(policies);
    }

    public void setSecurityPoliciesById(String ... ids) {
        if (ids != null) {
            this.setSecurityPoliciesById(Arrays.asList(ids));
        } else {
            this.setSecurityPoliciesById((Collection<String>)null);
        }
    }

    public void setUserAuthenticationCredentials(String userAuthenticationCredentials) {
        if (userAuthenticationCredentials != null) {
            this.userMap = new HashMap<String, String>();
            for (String creds : userAuthenticationCredentials.split(",")) {
                String[] toks = creds.split(":", 2);
                if (toks.length != 2) continue;
                try {
                    this.userMap.put(URLDecoder.decode(toks[0], URL_CHARSET), URLDecoder.decode(toks[1], URL_CHARSET));
                }
                catch (UnsupportedEncodingException e) {
                    LOG.warn("Failed to decode user map entry", (Throwable)e);
                }
            }
        } else {
            this.userMap = null;
        }
    }

    public void setEnableAnonymousAuthentication(boolean enableAnonymousAuthentication) {
        this.enableAnonymousAuthentication = enableAnonymousAuthentication;
    }

    public void setUsernameSecurityPolicyUri(SecurityPolicy usernameSecurityPolicy) {
        this.usernameSecurityPolicyUri = usernameSecurityPolicy.getSecurityPolicyUri();
    }

    public void setUsernameSecurityPolicyUri(String usernameSecurityPolicyUri) {
        this.usernameSecurityPolicyUri = usernameSecurityPolicyUri;
    }

    public void setBindAddresses(String bindAddresses) {
        this.bindAddresses = bindAddresses != null ? Arrays.asList(bindAddresses.split(",")) : null;
    }

    public void setBuildInfo(BuildInfo buildInfo) {
        this.serverConfig.setBuildInfo(buildInfo);
    }

    public void setServerCertificate(KeyStoreLoader.Result result) {
        Objects.requireNonNull(result, "Setting a null is not supported. call setCertificateManager(null) instead.)");
        this.setServerCertificate(result.getKeyPair(), result.getCertificate());
    }

    public void setServerCertificate(KeyPair keyPair, X509Certificate certificate) {
        this.setCertificateManager((CertificateManager)new DefaultCertificateManager(keyPair, certificate));
    }

    public void setCertificateManager(CertificateManager certificateManager) {
        if (certificateManager != null) {
            this.serverConfig.setCertificateManager(certificateManager);
        } else {
            this.serverConfig.setCertificateManager((CertificateManager)new DefaultCertificateManager());
        }
    }

    public void setCertificateValidator(Supplier<CertificateValidator> certificateValidator) {
        this.certificateValidator = certificateValidator;
    }

    public void setDefaultCertificateValidator(File certificatesBaseDir) {
        this.certificateValidator = () -> new DefaultCertificateValidator(certificatesBaseDir);
    }

    static {
        OpcUaServerConfigBuilder cfg = OpcUaServerConfig.builder();
        cfg.setCertificateManager((CertificateManager)new DefaultCertificateManager());
        cfg.setCertificateValidator(DenyAllCertificateValidator.INSTANCE);
        cfg.setSecurityPolicies(EnumSet.allOf(SecurityPolicy.class));
        cfg.setApplicationName(LocalizedText.english((String)"Apache Camel Milo Server"));
        cfg.setApplicationUri("urn:org:apache:camel:milo:server");
        cfg.setProductUri("urn:org:apache:camel:milo");
        if (Boolean.getBoolean("org.apache.camel.milo.server.default.enableAnonymous")) {
            cfg.setUserTokenPolicies(Collections.singletonList(OpcUaServerConfig.USER_TOKEN_POLICY_ANONYMOUS));
            cfg.setIdentityValidator(AnonymousIdentityValidator.INSTANCE);
        }
        DEFAULT_SERVER_CONFIG = cfg.build();
    }

    private static final class DenyAllCertificateValidator
    implements CertificateValidator {
        public static final CertificateValidator INSTANCE = new DenyAllCertificateValidator();

        private DenyAllCertificateValidator() {
        }

        public void validate(X509Certificate certificate) throws UaException {
            throw new UaException(0x80180000L);
        }

        public void verifyTrustChain(List<X509Certificate> certificateChain) throws UaException {
            throw new UaException(0x80180000L);
        }
    }
}

