/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics;

import java.util.List;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.microprofile.metrics.AbstractMicroProfileMetricsProducer;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsEndpoint;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;

public class MicroProfileMetricsCounterProducer
extends AbstractMicroProfileMetricsProducer<Counter> {
    public MicroProfileMetricsCounterProducer(MicroProfileMetricsEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    @Override
    protected void doProcess(Exchange exchange, MicroProfileMetricsEndpoint endpoint, Counter counter) {
        Long increment = this.getLongHeader(exchange.getIn(), "CamelMicroProfileMetricsCounterIncrement", endpoint.getCounterIncrement());
        if (increment != null) {
            counter.inc(increment.longValue());
        } else {
            counter.inc();
        }
    }

    @Override
    protected Function<MetricRegistry, Counter> registerMetric(Metadata metadata, List<Tag> tags) {
        return metricRegistry -> metricRegistry.counter(metadata, tags.toArray(new Tag[0]));
    }
}

