/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsEndpoint;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsHelper;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

public abstract class AbstractMicroProfileMetricsProducer<T extends Metric>
extends DefaultProducer {
    private static final String HEADER_PATTERN = "CamelMicroProfileMetrics*";

    public AbstractMicroProfileMetricsProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public MicroProfileMetricsEndpoint getEndpoint() {
        return (MicroProfileMetricsEndpoint)super.getEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        MicroProfileMetricsEndpoint endpoint = this.getEndpoint();
        Message in = exchange.getIn();
        String metricName = this.getStringHeader(in, "CamelMicroProfileMetricsName", endpoint.getMetricName());
        String metricDescription = this.getStringHeader(in, "CamelMicroProfileMetricsDescription", endpoint.getDescription());
        String metricDisplayName = this.getStringHeader(in, "CamelMicroProfileMetricsDisplayName", endpoint.getDisplayName());
        String metricUnit = this.getStringHeader(in, "CamelMicroProfileMetricsUnits", endpoint.getMetricUnit());
        MetricType metricType = (MetricType)exchange.getIn().getHeader("CamelMicroProfileMetricsType", (Object)endpoint.getMetricType(), MetricType.class);
        ArrayList<Tag> allTags = new ArrayList<Tag>();
        allTags.addAll(MicroProfileMetricsHelper.getMetricsTag(endpoint.getTags()));
        String headerTags = this.getStringHeader(in, "CamelMicroProfileMetricsTags", "");
        allTags.addAll(MicroProfileMetricsHelper.getMetricsTag(headerTags));
        List<Tag> finalTags = allTags.stream().map(tag -> MicroProfileMetricsHelper.parseTag(tag.getTagName() + "=" + tag.getTagValue())).collect(Collectors.toList());
        finalTags.add(MicroProfileMetricsHelper.parseTag("camelContext=" + this.getEndpoint().getCamelContext().getName()));
        MetadataBuilder builder = new MetadataBuilder().withName(metricName).withType(metricType);
        if (metricDescription != null) {
            builder.withDescription(metricDescription);
        }
        if (metricDisplayName != null) {
            builder.withDisplayName(metricDisplayName);
        }
        if (metricUnit != null) {
            builder.withUnit(metricUnit);
        }
        try {
            this.doProcess(exchange, builder.build(), finalTags);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            this.clearMetricsHeaders(in);
        }
    }

    protected void doProcess(Exchange exchange, Metadata metadata, List<Tag> tags) {
        this.doProcess(exchange, this.getEndpoint(), this.getOrRegisterMetric(metadata, tags));
    }

    protected T getOrRegisterMetric(Metadata metadata, List<Tag> tags) {
        MetricRegistry metricRegistry = this.getEndpoint().getMetricRegistry();
        return (T)((Metric)this.registerMetric(metadata, tags).apply(metricRegistry));
    }

    protected String getStringHeader(Message in, String header, String defaultValue) {
        String headerValue = (String)in.getHeader(header, String.class);
        return ObjectHelper.isNotEmpty((String)headerValue) ? headerValue : defaultValue;
    }

    protected Long getLongHeader(Message in, String header, Long defaultValue) {
        return (Long)in.getHeader(header, (Object)defaultValue, Long.class);
    }

    protected Boolean getBooleanHeader(Message in, String header, Boolean defaultValue) {
        Boolean headerValue = (Boolean)in.getHeader(header, Boolean.class);
        return ObjectHelper.isNotEmpty((Object)headerValue) ? headerValue : defaultValue;
    }

    protected Number getNumericHeader(Message in, String header, Number defaultValue) {
        Number headerValue = (Number)in.getHeader(header, Number.class);
        return ObjectHelper.isNotEmpty((Object)headerValue) ? (Number)headerValue : (Number)defaultValue;
    }

    protected void clearMetricsHeaders(Message in) {
        in.removeHeaders(HEADER_PATTERN);
    }

    protected abstract void doProcess(Exchange var1, MicroProfileMetricsEndpoint var2, T var3);

    protected abstract Function<MetricRegistry, T> registerMetric(Metadata var1, List<Tag> var2);
}

