/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics.message.history;

import org.apache.camel.Message;
import org.apache.camel.NamedNode;
import org.apache.camel.Route;
import org.apache.camel.component.microprofile.metrics.message.history.MicroProfileMetricsMessageHistoryNamingStrategy;
import org.apache.camel.support.DefaultMessageHistory;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Timer;

public class MicroProfileMetricsMessageHistory
extends DefaultMessageHistory {
    private final Timer.Context context;

    public MicroProfileMetricsMessageHistory(MetricRegistry metricRegistry, Route route, NamedNode namedNode, MicroProfileMetricsMessageHistoryNamingStrategy namingStrategy, long timestamp, Message message) {
        super(route.getId(), namedNode, timestamp, message);
        Metadata routeNodeMetadata = new MetadataBuilder().withName(namingStrategy.getName(route, this.getNode())).withDisplayName("Route node processing time").withDescription("The time taken to process an individual route node").build();
        this.context = metricRegistry.timer(routeNodeMetadata, namingStrategy.getTags(route, this.getNode())).time();
    }

    public void nodeProcessingDone() {
        super.nodeProcessingDone();
        this.context.stop();
    }

    public String toString() {
        return "MicroProfileMetricsMessageHistory[routeId=" + this.getRouteId() + ", node=" + this.getNode().getId() + "]";
    }
}

