/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.microprofile.health;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.microprofile.health.CamelMicroProfileHealthHelper;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

final class CamelMicroProfileRepositoryHealthCheck
implements org.eclipse.microprofile.health.HealthCheck {
    private final CamelContext camelContext;
    private final HealthCheckRepository repository;
    private final String name;

    CamelMicroProfileRepositoryHealthCheck(CamelContext camelContext, HealthCheckRepository repository, String name) {
        this.camelContext = camelContext;
        this.repository = repository;
        this.name = name;
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.builder();
        builder.name(this.name);
        builder.up();
        if (this.repository.isEnabled()) {
            List results = this.repository.stream().filter(HealthCheck::isEnabled).map(HealthCheck::call).filter(Objects::nonNull).collect(Collectors.toList());
            HealthCheckRegistry registry = HealthCheckRegistry.get((CamelContext)this.camelContext);
            results.stream().filter(result -> result.getState().equals((Object)HealthCheck.State.DOWN)).findFirst().ifPresent(result -> {
                CamelMicroProfileHealthHelper.applyHealthDetail(builder, result, registry.getExposureLevel());
                builder.down();
            });
        } else {
            builder.withData("check.enabled", false);
        }
        return builder.build();
    }
}

