/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.microprofile.health;

import java.util.Set;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.support.ExceptionHelper;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

final class CamelMicroProfileHealthHelper {
    private CamelMicroProfileHealthHelper() {
    }

    public static void applyHealthDetail(HealthCheckResponseBuilder builder, HealthCheck.Result result, String exposureLevel) {
        if (!exposureLevel.equals("oneline")) {
            HealthCheck check = result.getCheck();
            Set metaKeys = check.getMetaData().keySet();
            result.getDetails().forEach((key, value) -> {
                if (value != null) {
                    if (exposureLevel.equals("full")) {
                        builder.withData(key, value.toString());
                    } else if (!metaKeys.contains(key)) {
                        builder.withData(key, value.toString());
                    }
                }
            });
            result.getError().ifPresent(error -> {
                builder.withData("error.message", error.getMessage());
                String s = ExceptionHelper.stackTraceToString((Throwable)error);
                builder.withData("error.stacktrace", s);
            });
        }
    }
}

