/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.microprofile.health;

import io.smallrye.health.api.HealthRegistry;
import io.smallrye.health.api.HealthType;
import io.smallrye.health.registry.HealthRegistries;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.camel.CamelContext;
import org.apache.camel.StartupListener;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.health.ComponentsHealthCheckRepository;
import org.apache.camel.impl.health.ConsumersHealthCheckRepository;
import org.apache.camel.impl.health.DefaultHealthCheckRegistry;
import org.apache.camel.impl.health.HealthCheckRegistryRepository;
import org.apache.camel.impl.health.RoutesHealthCheckRepository;
import org.apache.camel.microprofile.health.CamelMicroProfileHealthCheck;
import org.apache.camel.microprofile.health.CamelMicroProfileRepositoryHealthCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelMicroProfileHealthCheckRegistry
extends DefaultHealthCheckRegistry
implements StartupListener {
    private static final Logger LOG = LoggerFactory.getLogger(CamelMicroProfileHealthCheckRegistry.class);
    private final Set<HealthCheckRepository> repositories = new CopyOnWriteArraySet<HealthCheckRepository>();

    public CamelMicroProfileHealthCheckRegistry() {
        this(null);
    }

    public CamelMicroProfileHealthCheckRegistry(CamelContext camelContext) {
        super(camelContext);
        super.setId("camel-microprofile-health");
    }

    protected void doInit() throws Exception {
        super.doInit();
        super.getCamelContext().addStartupListener((StartupListener)this);
    }

    public boolean register(Object obj) {
        boolean registered = super.register(obj);
        if (obj instanceof HealthCheck) {
            HealthCheck check = (HealthCheck)obj;
            if (check.isEnabled()) {
                this.registerMicroProfileHealthCheck(check);
            }
        } else {
            HealthCheckRepository repository = (HealthCheckRepository)obj;
            if (this.canRegister(repository)) {
                this.registerRepositoryChecks(repository);
            } else {
                this.repositories.add(repository);
            }
        }
        return registered;
    }

    public boolean unregister(Object obj) {
        boolean unregistered;
        block8: {
            unregistered = super.unregister(obj);
            if (obj instanceof HealthCheck) {
                HealthCheck check = (HealthCheck)obj;
                this.removeMicroProfileHealthCheck(check);
            } else {
                HealthCheckRepository repository = (HealthCheckRepository)obj;
                boolean isAllChecksLiveness = repository.stream().allMatch(HealthCheck::isLiveness);
                boolean isAllChecksReadiness = repository.stream().allMatch(HealthCheck::isReadiness);
                if (!(repository instanceof HealthCheckRegistryRepository) && (isAllChecksLiveness || isAllChecksReadiness)) {
                    try {
                        if (isAllChecksLiveness) {
                            this.getLivenessRegistry().remove(repository.getId());
                        }
                        if (isAllChecksReadiness) {
                            this.getReadinessRegistry().remove(repository.getId());
                        }
                        break block8;
                    }
                    catch (IllegalStateException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Failed to remove repository readiness health {} check due to: {}", (Object)repository.getId(), (Object)e.getMessage());
                        }
                        break block8;
                    }
                }
                repository.stream().forEach(this::removeMicroProfileHealthCheck);
            }
        }
        return unregistered;
    }

    public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
    }

    public void onCamelContextFullyStarted(CamelContext context, boolean alreadyStarted) throws Exception {
        if (alreadyStarted) {
            this.repositories.stream().filter(repository -> repository.stream().findAny().isPresent()).forEach(this::registerRepositoryChecks);
            this.repositories.clear();
        }
    }

    protected void registerRepositoryChecks(HealthCheckRepository repository) {
        if (repository.isEnabled()) {
            boolean isAllChecksLiveness = repository.stream().allMatch(HealthCheck::isLiveness);
            boolean isAllChecksReadiness = repository.stream().allMatch(HealthCheck::isReadiness);
            if (repository instanceof HealthCheckRegistryRepository || !isAllChecksLiveness && !isAllChecksReadiness) {
                repository.stream().filter(HealthCheck::isEnabled).forEach(this::registerMicroProfileHealthCheck);
            } else {
                Object healthCheckName = repository.getId();
                if (repository.getClass().getName().startsWith("org.apache.camel") && !((String)healthCheckName).startsWith("camel-")) {
                    healthCheckName = "camel-" + (String)healthCheckName;
                }
                CamelMicroProfileRepositoryHealthCheck repositoryHealthCheck = new CamelMicroProfileRepositoryHealthCheck(this.getCamelContext(), repository, (String)healthCheckName);
                if (this.registerEagerly(repository)) {
                    this.getReadinessRegistry().register(repository.getId(), (org.eclipse.microprofile.health.HealthCheck)repositoryHealthCheck);
                } else {
                    if (isAllChecksLiveness) {
                        this.getLivenessRegistry().register(repository.getId(), (org.eclipse.microprofile.health.HealthCheck)repositoryHealthCheck);
                    }
                    if (isAllChecksReadiness) {
                        this.getReadinessRegistry().register(repository.getId(), (org.eclipse.microprofile.health.HealthCheck)repositoryHealthCheck);
                    }
                }
            }
        }
    }

    protected void registerMicroProfileHealthCheck(HealthCheck camelHealthCheck) {
        CamelMicroProfileHealthCheck microProfileHealthCheck = new CamelMicroProfileHealthCheck(this.getCamelContext(), camelHealthCheck);
        if (camelHealthCheck.isReadiness()) {
            this.getReadinessRegistry().register(camelHealthCheck.getId(), (org.eclipse.microprofile.health.HealthCheck)microProfileHealthCheck);
        }
        if (camelHealthCheck.isLiveness()) {
            this.getLivenessRegistry().register(camelHealthCheck.getId(), (org.eclipse.microprofile.health.HealthCheck)microProfileHealthCheck);
        }
    }

    protected void removeMicroProfileHealthCheck(HealthCheck camelHealthCheck) {
        block7: {
            block6: {
                if (camelHealthCheck.isReadiness()) {
                    try {
                        this.getReadinessRegistry().remove(camelHealthCheck.getId());
                    }
                    catch (IllegalStateException e) {
                        if (!LOG.isDebugEnabled()) break block6;
                        LOG.debug("Failed to remove readiness health check due to: {}", (Object)e.getMessage());
                    }
                }
            }
            if (camelHealthCheck.isLiveness()) {
                try {
                    this.getLivenessRegistry().remove(camelHealthCheck.getId());
                }
                catch (IllegalStateException e) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug("Failed to remove liveness health check due to: {}", (Object)e.getMessage());
                }
            }
        }
    }

    protected boolean canRegister(HealthCheckRepository repository) {
        return repository.stream().findAny().isPresent() || repository instanceof RoutesHealthCheckRepository || repository instanceof ConsumersHealthCheckRepository || repository instanceof ComponentsHealthCheckRepository;
    }

    protected boolean registerEagerly(HealthCheckRepository repository) {
        return repository instanceof RoutesHealthCheckRepository || repository instanceof ConsumersHealthCheckRepository || repository instanceof ComponentsHealthCheckRepository;
    }

    protected HealthRegistry getLivenessRegistry() {
        return HealthRegistries.getRegistry((HealthType)HealthType.LIVENESS);
    }

    protected HealthRegistry getReadinessRegistry() {
        return HealthRegistries.getRegistry((HealthType)HealthType.READINESS);
    }
}

