/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.faulttolerance;

import io.smallrye.faulttolerance.core.timer.ThreadTimer;
import io.smallrye.faulttolerance.core.timer.Timer;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.support.service.ServiceSupport;

public class FaultToleranceTimerService
extends ServiceSupport
implements CamelContextAware {
    private ExecutorService threadTimerExecutorService;
    private Timer timer;
    private CamelContext camelContext;

    protected void doInit() throws Exception {
        this.threadTimerExecutorService = this.getCamelContext().getExecutorServiceManager().newCachedThreadPool((Object)this, "CircuitBreakerThreadTimer");
        this.timer = new ThreadTimer((Executor)this.threadTimerExecutorService);
    }

    protected void doStop() throws Exception {
        if (this.timer != null) {
            try {
                this.timer.shutdown();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.timer = null;
            }
        }
        if (this.threadTimerExecutorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.threadTimerExecutorService);
            this.threadTimerExecutorService = null;
        }
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Timer getTimer() {
        return this.timer;
    }
}

