/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer;

import io.micrometer.core.instrument.Meter;
import java.util.function.Predicate;
import org.apache.camel.spi.Metadata;

public final class MicrometerConstants {
    public static final String HEADER_PREFIX = "CamelMetrics";
    @Metadata(description="Override timer action in URI", javaType="org.apache.camel.component.micrometer.MicrometerTimerAction")
    public static final String HEADER_TIMER_ACTION = "CamelMetricsTimerAction";
    @Metadata(description="Override histogram value in URI", javaType="long")
    public static final String HEADER_HISTOGRAM_VALUE = "CamelMetricsHistogramValue";
    @Metadata(description="Override decrement value in URI", javaType="Double")
    public static final String HEADER_COUNTER_DECREMENT = "CamelMetricsCounterDecrement";
    @Metadata(description="Override increment value in URI", javaType="Double")
    public static final String HEADER_COUNTER_INCREMENT = "CamelMetricsCounterIncrement";
    @Metadata(description="Override name value in URI", javaType="String")
    public static final String HEADER_METRIC_NAME = "CamelMetricsName";
    @Metadata(description="Override description value in URI", javaType="String")
    public static final String HEADER_METRIC_DESCRIPTION = "CamelMetricsDescription";
    @Metadata(description="To augment meter tags defined as URI parameters", javaType="java.lang.Iterable<Tag>")
    public static final String HEADER_METRIC_TAGS = "CamelMetricsTags";
    public static final String DEFAULT_CAMEL_MESSAGE_HISTORY_METER_NAME = "camel.message.history";
    public static final String DEFAULT_CAMEL_ROUTE_POLICY_EXCHANGES_FAILED_METER_NAME = "camel.exchanges.failed";
    public static final String DEFAULT_CAMEL_ROUTE_POLICY_EXCHANGES_SUCCEEDED_METER_NAME = "camel.exchanges.succeeded";
    public static final String DEFAULT_CAMEL_ROUTE_POLICY_EXCHANGES_TOTAL_METER_NAME = "camel.exchanges.total";
    public static final String DEFAULT_CAMEL_ROUTE_POLICY_EXCHANGES_FAILURES_HANDLED_METER_NAME = "camel.exchanges.failures.handled";
    public static final String DEFAULT_CAMEL_ROUTE_POLICY_EXCHANGES_EXTERNAL_REDELIVERIES_METER_NAME = "camel.exchanges.external.redeliveries";
    public static final String DEFAULT_CAMEL_ROUTES_EXCHANGES_INFLIGHT = "camel.exchanges.inflight";
    public static final String DEFAULT_CAMEL_ROUTE_POLICY_METER_NAME = "camel.route.policy";
    public static final String DEFAULT_CAMEL_ROUTE_POLICY_LONGMETER_NAME = "camel.route.policy.long.task";
    public static final String DEFAULT_CAMEL_EXCHANGE_EVENT_METER_NAME = "camel.exchange.event.notifier";
    public static final String DEFAULT_CAMEL_ROUTES_ADDED = "camel.routes.added";
    public static final String DEFAULT_CAMEL_ROUTES_RUNNING = "camel.routes.running";
    public static final String DEFAULT_CAMEL_ROUTES_RELOADED = "camel.routes.reloaded";
    public static final String ROUTE_ID_TAG = "routeId";
    public static final String NODE_ID_TAG = "nodeId";
    public static final String FAILED_TAG = "failed";
    public static final String CAMEL_CONTEXT_TAG = "camelContext";
    public static final String EVENT_TYPE_TAG = "eventType";
    public static final String METRICS_REGISTRY_NAME = "metricsRegistry";
    public static final String SERVICE_NAME = "serviceName";
    public static final String ENDPOINT_NAME = "endpointName";
    public static final Predicate<Meter.Id> CAMEL_METERS = id -> id.getTag(CAMEL_CONTEXT_TAG) != null;
    public static final Predicate<Meter.Id> ALWAYS = id -> true;

    private MicrometerConstants() {
    }
}

