/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.metrics;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum MetricsType {
    GAUGE("gauge"),
    COUNTER("counter"),
    HISTOGRAM("histogram"),
    METER("meter"),
    TIMER("timer");

    private static final Map<String, MetricsType> MAP;
    private final String name;

    private MetricsType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static MetricsType getByName(String name) {
        return MAP.get(name);
    }

    static {
        MAP = new HashMap<String, MetricsType>();
        for (MetricsType type : EnumSet.allOf(MetricsType.class)) {
            MAP.put(type.name, type);
        }
    }
}

