/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.metrics.MetricsEndpoint;
import org.apache.camel.component.metrics.MetricsType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.apache.camel.spi.annotations.Component(value="metrics")
public class MetricsComponent
extends DefaultComponent {
    public static final String METRIC_REGISTRY_NAME = "metricRegistry";
    public static final MetricsType DEFAULT_METRICS_TYPE = MetricsType.METER;
    public static final long DEFAULT_REPORTING_INTERVAL_SECONDS = 60L;
    private static final Logger LOG = LoggerFactory.getLogger(MetricsComponent.class);
    @Metadata(label="advanced")
    private MetricRegistry metricRegistry;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String metricsName = this.getMetricsName(remaining);
        MetricsType metricsType = this.getMetricsType(remaining);
        LOG.debug("Metrics type: {}; name: {}", (Object)metricsType, (Object)metricsName);
        MetricsEndpoint endpoint = new MetricsEndpoint(uri, (Component)this, this.metricRegistry, metricsType, metricsName);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    String getMetricsName(String remaining) {
        String name = StringHelper.after((String)remaining, (String)":");
        return name == null ? remaining : name;
    }

    MetricsType getMetricsType(String remaining) {
        String name = StringHelper.before((String)remaining, (String)":");
        MetricsType type = name == null ? DEFAULT_METRICS_TYPE : MetricsType.getByName(name);
        if (type == null) {
            throw new RuntimeCamelException("Unknown metrics type \"" + name + "\"");
        }
        return type;
    }

    static MetricRegistry getOrCreateMetricRegistry(Registry camelRegistry, String registryName) {
        LOG.debug("Looking up MetricRegistry from Camel Registry for name \"{}\"", (Object)registryName);
        MetricRegistry result = MetricsComponent.getMetricRegistryFromCamelRegistry(camelRegistry, registryName);
        if (result == null) {
            LOG.debug("MetricRegistry not found from Camel Registry for name \"{}\"", (Object)registryName);
            LOG.info("Creating new default MetricRegistry");
            result = MetricsComponent.createMetricRegistry();
        }
        return result;
    }

    static MetricRegistry getMetricRegistryFromCamelRegistry(Registry camelRegistry, String registryName) {
        MetricRegistry registry = (MetricRegistry)camelRegistry.lookupByNameAndType(registryName, MetricRegistry.class);
        if (registry != null) {
            return registry;
        }
        Set registries = camelRegistry.findByType(MetricRegistry.class);
        if (registries.size() == 1) {
            return (MetricRegistry)registries.iterator().next();
        }
        return null;
    }

    static MetricRegistry createMetricRegistry() {
        MetricRegistry registry = new MetricRegistry();
        Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)registry).outputTo(LOG).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).withLoggingLevel(Slf4jReporter.LoggingLevel.DEBUG).build();
        reporter.start(60L, TimeUnit.SECONDS);
        return registry;
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.metricRegistry == null) {
            Registry camelRegistry = this.getCamelContext().getRegistry();
            this.metricRegistry = MetricsComponent.getOrCreateMetricRegistry(camelRegistry, METRIC_REGISTRY_NAME);
        }
        ObjectHelper.notNull((Object)this.metricRegistry, (String)"MetricsRegistry", (Object)((Object)this));
    }
}

