/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.metrics;

import com.codahale.metrics.MetricRegistry;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.metrics.MetricsEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public abstract class AbstractMetricsProducer
extends DefaultProducer {
    public static final String HEADER_PATTERN = "CamelMetrics*";

    public AbstractMetricsProducer(MetricsEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public MetricsEndpoint getEndpoint() {
        return (MetricsEndpoint)super.getEndpoint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String defaultMetricsName = this.getEndpoint().getMetricsName();
        String finalMetricsName = this.getMetricsName(in, defaultMetricsName);
        MetricRegistry registry = this.getEndpoint().getRegistry();
        try {
            this.doProcess(exchange, this.getEndpoint(), registry, finalMetricsName);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            this.clearMetricsHeaders(in);
        }
    }

    protected abstract void doProcess(Exchange var1, MetricsEndpoint var2, MetricRegistry var3, String var4) throws Exception;

    public String getMetricsName(Message in, String defaultValue) {
        return this.getStringHeader(in, "CamelMetricsName", defaultValue);
    }

    public String getStringHeader(Message in, String header, String defaultValue) {
        String headerValue = (String)in.getHeader(header, String.class);
        return ObjectHelper.isNotEmpty((String)headerValue) ? headerValue : defaultValue;
    }

    public Long getLongHeader(Message in, String header, Long defaultValue) {
        return (Long)in.getHeader(header, (Object)defaultValue, Long.class);
    }

    protected boolean clearMetricsHeaders(Message in) {
        return in.removeHeaders(HEADER_PATTERN);
    }
}

