/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.helper;

import java.util.regex.PatternSyntaxException;

public final class EndpointHelper {
    private EndpointHelper() {
    }

    public static boolean matchPattern(String name, String pattern) {
        if (name == null || pattern == null) {
            return false;
        }
        if (name.equals(pattern)) {
            return true;
        }
        if (EndpointHelper.matchWildcard(name, pattern)) {
            return true;
        }
        return EndpointHelper.matchRegex(name, pattern);
    }

    private static boolean matchWildcard(String name, String pattern) {
        return pattern.endsWith("*") && name.startsWith(pattern.substring(0, pattern.length() - 1));
    }

    private static boolean matchRegex(String name, String pattern) {
        try {
            if (name.matches(pattern)) {
                return true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return false;
    }
}

