/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedPollMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.PollDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.PollEnricher;
import org.apache.camel.processor.PollProcessor;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.URISupport;

@ManagedResource(description="Managed Poll")
public class ManagedPoll
extends ManagedProcessor
implements ManagedPollMBean {
    private final PollProcessor processor;
    private String uri;
    private boolean sanitize;

    public ManagedPoll(CamelContext context, PollProcessor processor, PollDefinition definition) {
        super(context, (Processor)processor, (ProcessorDefinition<?>)definition);
        this.processor = processor;
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.sanitize = strategy.getManagementAgent().getMask() != null ? strategy.getManagementAgent().getMask() : true;
        this.uri = this.processor.getUri();
        if (this.sanitize) {
            this.uri = URISupport.sanitizeUri((String)this.uri);
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.processor.getEndpointUtilizationStatistics() != null) {
            this.processor.getEndpointUtilizationStatistics().clear();
        }
    }

    @Override
    public Boolean getSupportExtendedInformation() {
        return true;
    }

    public PollDefinition getDefinition() {
        return (PollDefinition)super.getDefinition();
    }

    public PollEnricher getProcessor() {
        return this.processor;
    }

    public String getDestination() {
        return this.uri;
    }

    public String getVariableReceive() {
        return this.processor.getVariableReceive();
    }

    public Long getTimeout() {
        return this.processor.getTimeout();
    }

    public TabularData extendedInformation() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.endpointsUtilizationTabularType());
            EndpointUtilizationStatistics stats = this.processor.getEndpointUtilizationStatistics();
            if (stats != null) {
                for (Map.Entry entry : stats.getStatistics().entrySet()) {
                    Long hits;
                    CompositeType ct = CamelOpenMBeanTypes.endpointsUtilizationCompositeType();
                    String url = (String)entry.getKey();
                    if (this.sanitize) {
                        url = URISupport.sanitizeUri((String)url);
                    }
                    if ((hits = (Long)entry.getValue()) == null) {
                        hits = 0L;
                    }
                    CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"url", "hits"}, new Object[]{url, hits});
                    answer.put(data);
                }
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

