/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.LoadBalanceDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedWeightedLoadBalancerTest
extends ManagementTestSupport {
    @Test
    public void testManageWeightedLoadBalancer() throws Exception {
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(1);
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMessageCount(2);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)"123");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hi World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("processors", "mysend");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)this.context.getManagementName(), (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        Integer size = (Integer)mbeanServer.getAttribute(on, "Size");
        Assertions.assertEquals((int)2, (int)size);
        String roundRobin = (String)mbeanServer.getAttribute(on, "RoundRobin");
        Assertions.assertEquals((Object)Boolean.toString(true), (Object)roundRobin);
        String ratio = (String)mbeanServer.getAttribute(on, "DistributionRatio");
        Assertions.assertEquals((Object)"1,2", (Object)ratio);
        String delim = (String)mbeanServer.getAttribute(on, "DistributionRatioDelimiter");
        Assertions.assertEquals((Object)",", (Object)delim);
        String last = (String)mbeanServer.getAttribute(on, "LastChosenProcessorId");
        Assertions.assertEquals((Object)"bar", (Object)last);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((LoadBalanceDefinition)((LoadBalanceDefinition)((LoadBalanceDefinition)((LoadBalanceDefinition)this.from("direct:start").loadBalance().weighted(true, "1,2").id("mysend")).to("mock:foo")).id("foo")).to("mock:bar")).id("bar");
            }
        };
    }
}

