/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedDisabledTest
extends ManagementTestSupport {
    @Test
    public void testManageDisabled() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:baz").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"123");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("processors", "mychoice");
        String type = (String)mbeanServer.getAttribute(on, "NodeType");
        Assertions.assertEquals((Object)"choice", (Object)type);
        on = this.getCamelObjectName("processors", "mybaz");
        type = (String)mbeanServer.getAttribute(on, "NodeType");
        Assertions.assertEquals((Object)"to", (Object)type);
        on = this.getCamelObjectName("processors", "mylog");
        type = (String)mbeanServer.getAttribute(on, "NodeType");
        Assertions.assertEquals((Object)"log", (Object)type);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).choice().disabled()).id("mychoice")).when((Predicate)this.xpath("/bar")).to("mock:bar")).when((Predicate)this.xpath("/baz")).to("mock:baz")).end().to("mock:baz").disabled(true).id("mybaz").log("Hello World").disabled("true").id("mylog").to("mock:result");
            }
        };
    }
}

