/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.support.cache.DefaultConsumerCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedConsumerCacheTest
extends ManagementTestSupport {
    @Test
    public void testManageConsumerCache() throws Exception {
        this.context.getManagementStrategy().getManagementAgent().setRegisterAlways(Boolean.valueOf(true));
        DefaultConsumerCache cache = new DefaultConsumerCache((Object)this, (CamelContext)this.context, 0);
        this.context.addService((Object)cache);
        this.template.sendBody("direct:start", (Object)"Hello World");
        Endpoint endpoint = this.context.getEndpoint("seda:queue");
        PollingConsumer consumer = cache.acquirePollingConsumer(endpoint);
        Exchange out = consumer.receive(3000L);
        Assertions.assertNotNull((Object)out, (String)"Should got an exchange");
        Assertions.assertEquals((Object)"Hello World", (Object)out.getIn().getBody());
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=services,*"), null);
        ArrayList<ObjectName> list = new ArrayList<ObjectName>(set);
        ObjectName on = null;
        for (ObjectName name : list) {
            if (!name.getCanonicalName().contains("ConsumerCache")) continue;
            on = name;
            break;
        }
        Assertions.assertNotNull(on, (String)"Should have found ConsumerCache");
        Integer max = (Integer)mbeanServer.getAttribute(on, "MaximumCacheSize");
        Assertions.assertEquals((int)1000, (int)max);
        Integer current = (Integer)mbeanServer.getAttribute(on, "Size");
        Assertions.assertEquals((int)1, (int)current);
        String source = (String)mbeanServer.getAttribute(on, "Source");
        Assertions.assertNotNull((Object)source);
        Assertions.assertTrue((boolean)source.contains("testManageConsumerCache"));
        mbeanServer.invoke(on, "purge", null, null);
        current = (Integer)mbeanServer.getAttribute(on, "Size");
        Assertions.assertEquals((int)0, (int)current);
        consumer.stop();
        cache.stop();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("seda:queue");
            }
        };
    }
}

