/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class JmxInstrumentationOnlyRegisterProcessorWithCustomIdTest
extends ManagementTestSupport {
    protected final String domainName = "org.apache.camel";
    protected MBeanServer server;

    @Test
    public void testCustomId() throws Exception {
        Set<ObjectName> s = this.server.queryNames(new ObjectName("org.apache.camel:type=endpoints,*"), null);
        Assertions.assertEquals((int)6, (int)s.size(), (String)("Could not find 2 endpoints: " + String.valueOf(s)));
        s = this.server.queryNames(new ObjectName("org.apache.camel:type=context,*"), null);
        Assertions.assertEquals((int)1, (int)s.size(), (String)("Could not find 1 context: " + String.valueOf(s)));
        s = this.server.queryNames(new ObjectName("org.apache.camel:type=processors,*"), null);
        Assertions.assertEquals((int)1, (int)s.size(), (String)("Could not find 1 processor: " + String.valueOf(s)));
        ObjectName on = s.iterator().next();
        String id = (String)this.server.getAttribute(on, "ProcessorId");
        Assertions.assertEquals((Object)"myfoo", (Object)id);
        s = this.server.queryNames(new ObjectName("org.apache.camel:type=routes,*"), null);
        Assertions.assertEquals((int)2, (int)s.size(), (String)("Could not find 2 route: " + String.valueOf(s)));
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getManagementStrategy().getManagementAgent().setOnlyRegisterProcessorWithCustomId(Boolean.valueOf(true));
        return context;
    }

    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = ManagementFactory.getPlatformMBeanServer();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).id("myfoo")).delay(10L).to("mock:result");
                ((RouteDefinition)this.from("direct:other").to("mock:bar")).delay(10L).to("mock:other");
            }
        };
    }
}

