/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.AbstractManagedThrottlerTest;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
@DisabledIfSystemProperty(named="ci.env.name", matches="github.com", disabledReason="Flaky on GitHub Actions")
public class ManagedThrottlerTest
extends AbstractManagedThrottlerTest {
    @Test
    public void testManageThrottler() throws Exception {
        Long total = super.runTestManageThrottler();
        Assertions.assertTrue((total > 1000L ? 1 : 0) != 0, (String)("Should be around 1 sec now: was " + total));
    }

    @Test
    public void testThrottleAsyncVisibleViaJmx() throws Exception {
        super.runTestThrottleAsyncVisibleViaJmx();
    }

    protected RouteBuilder createRouteBuilder() {
        final ScheduledThreadPoolExecutor badService = new ScheduledThreadPoolExecutor(1){

            @Override
            public <V> ScheduledFuture<V> schedule(Callable<V> command, long delay, TimeUnit unit) {
                throw new RejectedExecutionException();
            }
        };
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").id("route1")).to("log:foo")).throttle(10L).totalRequestsMode().id("mythrottler").delay(100L).to("mock:result");
                ((RouteDefinition)this.from("seda:throttleCount").id("route2")).throttle(1L).totalRequestsMode().id("mythrottler2").delay(250L).to("mock:end");
                ((RouteDefinition)this.from("seda:throttleCountAsync").id("route3")).throttle(1L).totalRequestsMode().asyncDelayed().id("mythrottler3").delay(250L).to("mock:endAsync");
                ((ExpressionNode)((RouteDefinition)this.from("seda:throttleCountAsyncException").id("route4")).throttle(1L).totalRequestsMode().asyncDelayed().id("mythrottler4").delay(250L).to("mock:endAsyncException")).process(exchange -> {
                    throw new RuntimeException("Fail me");
                });
                ((OnExceptionDefinition)((RouteDefinition)this.from("seda:throttleCountRejectExecutionCallerRuns").id("route5")).onException(RejectedExecutionException.class).to("mock:rejectedExceptionEndpoint1")).end().throttle(1L).totalRequestsMode().asyncDelayed().executorService((ExecutorService)badService).callerRunsWhenRejected(true).id("mythrottler5").delay(250L).to("mock:endAsyncRejectCallerRuns");
                ((OnExceptionDefinition)((RouteDefinition)this.from("seda:throttleCountRejectExecution").id("route6")).onException(RejectedExecutionException.class).to("mock:rejectedExceptionEndpoint1")).end().throttle(1L).totalRequestsMode().asyncDelayed().executorService((ExecutorService)badService).callerRunsWhenRejected(false).id("mythrottler6").delay(250L).to("mock:endAsyncReject");
            }
        };
    }
}

