/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.File;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultDumpRoutesStrategy;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRouteDumpStrategyTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        String dir = this.testDirectory().toString();
        CamelContext context = super.createCamelContext();
        context.setDumpRoutes("xml");
        DefaultDumpRoutesStrategy drd = new DefaultDumpRoutesStrategy();
        drd.setInclude("all");
        drd.setLog(false);
        drd.setOutput(dir);
        drd.setResolvePlaceholders(false);
        context.addService((Object)drd);
        return context;
    }

    @Test
    public void testDumpStrategy() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String mbeanName = String.format("org.apache.camel:context=" + this.context.getManagementName() + ",name=%s,type=services", DefaultDumpRoutesStrategy.class.getSimpleName());
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName(mbeanName), null);
        Assertions.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on));
        String include = (String)mbeanServer.getAttribute(on, "Include");
        Assertions.assertEquals((Object)"all", (Object)include);
        Boolean log = (Boolean)mbeanServer.getAttribute(on, "Log");
        Assertions.assertFalse((boolean)log);
        Boolean rp = (Boolean)mbeanServer.getAttribute(on, "ResolvePlaceholders");
        Assertions.assertFalse((boolean)rp);
        File dir = this.testDirectory().toFile();
        String[] files = dir.list();
        Assertions.assertNotNull((Object)files, (String)("There are no files in " + String.valueOf(dir)));
        Assertions.assertEquals((int)1, (int)files.length);
        Assertions.assertEquals((Object)"dump1.xml", (Object)files[0]);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").routeId("myRoute").log("Got ${body}")).to("mock:result");
            }
        };
    }
}

