/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.management.MyManagedBean;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.ManagementAgent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisabledOnOs(value={OS.AIX})
public class ManagedResourceTest
extends ManagementTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedResourceTest.class);

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").bean(MyManagedBean.class)).id("myManagedBean")).log("${body}")).to("seda:foo")).to("mock:result");
            }
        };
    }

    @Test
    public void testManagedResource() throws Exception {
        ManagementAgent managementAgent = this.context.getManagementStrategy().getManagementAgent();
        Assertions.assertNotNull((Object)managementAgent);
        MBeanServer mBeanServer = managementAgent.getMBeanServer();
        Assertions.assertNotNull((Object)mBeanServer);
        String mBeanServerDefaultDomain = managementAgent.getMBeanServerDefaultDomain();
        Assertions.assertEquals((Object)"org.apache.camel", (Object)mBeanServerDefaultDomain);
        String managementName = this.context.getManagementName();
        Assertions.assertNotNull((Object)managementName, (String)"CamelContext should have a management name if JMX is enabled");
        LOG.info("managementName = {}", (Object)managementName);
        ObjectName onContext = this.getContextObjectName();
        Assertions.assertTrue((boolean)mBeanServer.isRegistered(onContext), (String)"Should be registered");
        ObjectName onManagedBean = this.getCamelObjectName("processors", "myManagedBean");
        LOG.info("Canonical Name = {}", (Object)onManagedBean.getCanonicalName());
        Assertions.assertTrue((boolean)mBeanServer.isRegistered(onManagedBean), (String)"Should be registered");
        this.template.sendBody("direct:start", (Object)"Hello Camel");
        this.template.sendBody("direct:start", (Object)"Camel Rocks!");
        int camelsSeenCount = (Integer)mBeanServer.getAttribute(onManagedBean, "CamelsSeenCount");
        Assertions.assertEquals((int)2, (int)camelsSeenCount);
        mBeanServer.invoke(onManagedBean, "resetCamelsSeenCount", null, null);
        camelsSeenCount = (Integer)mBeanServer.getAttribute(onManagedBean, "CamelsSeenCount");
        Assertions.assertEquals((int)0, (int)camelsSeenCount);
        String camelId = (String)mBeanServer.getAttribute(onManagedBean, "CamelId");
        Assertions.assertEquals((Object)this.context.getName(), (Object)camelId);
        String state = (String)mBeanServer.getAttribute(onManagedBean, "State");
        Assertions.assertEquals((Object)"Started", (Object)state);
        String fqn = (String)mBeanServer.getAttribute(onManagedBean, "BeanClassName");
        Assertions.assertEquals((Object)MyManagedBean.class.getCanonicalName(), (Object)fqn);
    }
}

