/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockComponent;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedRefProducerTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.getRegistry().bind("foo", (Object)new MockEndpoint("mock://foo", (Component)new MockComponent(context)));
        return context;
    }

    @Test
    public void testProducer() throws Exception {
        String uri;
        boolean registered;
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("foo").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=producers,*"), null);
        Assertions.assertEquals((int)2, (int)set.size());
        for (ObjectName on : set) {
            registered = mbeanServer.isRegistered(on);
            Assertions.assertTrue((boolean)registered, (String)"Should be registered");
            uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
            Assertions.assertTrue((uri.equals("mock://foo") || uri.equals("mock://result") ? 1 : 0) != 0, (String)uri);
            String state = (String)mbeanServer.getAttribute(on, "State");
            Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state, (String)"Should be started");
        }
        set = mbeanServer.queryNames(new ObjectName("*:type=endpoints,*"), null);
        Assertions.assertEquals((int)4, (int)set.size());
        for (ObjectName on : set) {
            registered = mbeanServer.isRegistered(on);
            Assertions.assertTrue((boolean)registered, (String)"Should be registered");
            uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
            Assertions.assertTrue((uri.equals("direct://start") || uri.equals("ref://foo") || uri.equals("mock://foo") || uri.equals("mock://result") ? 1 : 0) != 0, (String)uri);
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").routeId("foo").to("ref:foo")).to("mock:result");
            }
        };
    }
}

