/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.parallel.ResourceLock;

@ResourceLock(value="java.lang.System.properties")
@DisabledOnOs(value={OS.AIX})
public class ManagedNamePatternJvmSystemPropertyTest
extends ManagementTestSupport {
    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("org.apache.camel.jmx.managementNamePattern", "cool-#name#");
        super.setUp();
    }

    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty("org.apache.camel.jmx.managementNamePattern");
        super.tearDown();
    }

    @Test
    public void testManagedNamePattern() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        Assertions.assertEquals((Object)("cool-" + this.context.getName()), (Object)this.context.getManagementName());
        ObjectName on = this.getContextObjectName();
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

