/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.LoadBalanceDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedLoadBalancerTest
extends ManagementTestSupport {
    @Test
    public void testLoadBalancer() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World", "Hi World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.template.sendBody("direct:start", (Object)"Hi World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = this.getCamelObjectName("endpoints", "mock://a");
        Long queueSize = (Long)mbeanServer.invoke(name, "queueSize", null, null);
        Assertions.assertEquals((int)2, (int)queueSize.intValue());
        name = this.getCamelObjectName("endpoints", "mock://b");
        queueSize = (Long)mbeanServer.invoke(name, "queueSize", null, null);
        Assertions.assertEquals((int)1, (int)queueSize.intValue());
        name = this.getCamelObjectName("processors", "myBalancer");
        mbeanServer.isRegistered(name);
        Long total = (Long)mbeanServer.getAttribute(name, "ExchangesTotal");
        Assertions.assertEquals((int)3, (int)total.intValue());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((LoadBalanceDefinition)((LoadBalanceDefinition)this.from("direct:start").routeId("foo").loadBalance().id("myBalancer")).roundRobin().to("mock:a")).to("mock:b");
            }
        };
    }
}

