/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.File;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.processor.idempotent.FileIdempotentRepository;
import org.apache.camel.util.FileUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedFileIdempotentConsumerTest
extends ManagementTestSupport {
    private IdempotentRepository repo;

    @Test
    public void testDuplicateMessagesAreFilteredOut() throws Exception {
        Endpoint startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> names = mbeanServer.queryNames(new ObjectName("org.apache.camel:type=services,*"), null);
        ObjectName on = null;
        for (ObjectName name : names) {
            if (!name.toString().contains("FileIdempotentRepository")) continue;
            on = name;
            break;
        }
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered");
        String path = (String)mbeanServer.getAttribute(on, "FilePath");
        Assertions.assertEquals((Object)FileUtil.normalizePath((String)this.testFile("idempotentfilestore.dat").toString()), (Object)FileUtil.normalizePath((String)path));
        Integer size = (Integer)mbeanServer.getAttribute(on, "CacheSize");
        Assertions.assertEquals((int)1, (int)size);
        Assertions.assertFalse((boolean)this.repo.contains("1"));
        Assertions.assertFalse((boolean)this.repo.contains("2"));
        Assertions.assertFalse((boolean)this.repo.contains("3"));
        Assertions.assertTrue((boolean)this.repo.contains("4"));
        resultEndpoint.expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.sendMessage(startEndpoint, "1", "one");
        this.sendMessage(startEndpoint, "2", "two");
        this.sendMessage(startEndpoint, "1", "one");
        this.sendMessage(startEndpoint, "2", "two");
        this.sendMessage(startEndpoint, "4", "four");
        this.sendMessage(startEndpoint, "1", "one");
        this.sendMessage(startEndpoint, "3", "three");
        resultEndpoint.assertIsSatisfied();
        Assertions.assertTrue((boolean)this.repo.contains("1"));
        Assertions.assertTrue((boolean)this.repo.contains("2"));
        Assertions.assertTrue((boolean)this.repo.contains("3"));
        Assertions.assertTrue((boolean)this.repo.contains("4"));
        size = (Integer)mbeanServer.getAttribute(on, "CacheSize");
        Assertions.assertEquals((int)4, (int)size);
        mbeanServer.invoke(on, "remove", new Object[]{"1"}, new String[]{"java.lang.String"});
        mbeanServer.invoke(on, "reset", null, null);
        size = (Integer)mbeanServer.getAttribute(on, "CacheSize");
        Assertions.assertEquals((int)3, (int)size);
        Assertions.assertFalse((boolean)this.repo.contains("1"));
        Assertions.assertTrue((boolean)this.repo.contains("2"));
        Assertions.assertTrue((boolean)this.repo.contains("3"));
        Assertions.assertTrue((boolean)this.repo.contains("4"));
    }

    protected void sendMessage(Endpoint startEndpoint, Object messageId, Object body) {
        this.template.send(startEndpoint, exchange -> {
            Message in = exchange.getIn();
            in.setBody(body);
            in.setHeader("messageId", messageId);
        });
    }

    protected RouteBuilder createRouteBuilder() {
        final File store = this.testFile("idempotentfilestore.dat").toFile();
        return new RouteBuilder(){

            public void configure() {
                ManagedFileIdempotentConsumerTest.this.repo = FileIdempotentRepository.fileIdempotentRepository((File)store);
                ManagedFileIdempotentConsumerTest.this.repo.add("4");
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), ManagedFileIdempotentConsumerTest.this.repo).to("mock:result");
            }
        };
    }
}

