/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Policy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedCustomPolicyTest
extends ManagementTestSupport {
    private final AtomicInteger counter = new AtomicInteger();

    @Test
    public void testPolicy() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)this.counter.get());
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        Assertions.assertEquals((int)3, (int)set.size());
        ObjectName on = this.getCamelObjectName("processors", "foo");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered: foo");
        on = this.getCamelObjectName("processors", "result");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered: result");
        on = this.getCamelObjectName("processors", "bar");
        Assertions.assertTrue((boolean)mbeanServer.isRegistered(on), (String)"Should be registered: bar");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:start").policy((Policy)new MyPolicy()).to("log:foo")).id("foo")).to("mock:result")).id("result");
                ((RouteDefinition)this.from("direct:bar").to("log:bar")).id("bar");
            }
        };
    }

    private final class MyPolicy
    implements Policy {
        private MyPolicy() {
        }

        public void beforeWrap(Route route, NamedNode definition) {
        }

        public Processor wrap(Route route, Processor processor) {
            return exchange -> {
                ManagedCustomPolicyTest.this.counter.incrementAndGet();
                processor.process(exchange);
            };
        }
    }
}

