/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.component.mock.MockComponent;
import org.apache.camel.management.CustomEndpoint;
import org.apache.camel.management.JmxInstrumentationUsingDefaultsTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class JmxInstrumentationCustomMBeanTest
extends JmxInstrumentationUsingDefaultsTest {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.addComponent("custom", (Component)new CustomComponent());
        return context;
    }

    @Test
    public void testCustomEndpoint() throws Exception {
        this.assertDefaultDomain();
        this.resolveMandatoryEndpoint("custom://end", CustomEndpoint.class);
        Set<ObjectName> s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=endpoints,*"), null);
        Assertions.assertEquals((int)2, (int)s.size(), (String)("Could not find 2 endpoints: " + String.valueOf(s)));
        Iterator<ObjectName> it = s.iterator();
        ObjectName on1 = it.next();
        ObjectName on2 = it.next();
        if (on1.getCanonicalName().contains("custom")) {
            Assertions.assertEquals((Object)"bar", (Object)this.mbsc.getAttribute(on1, "Foo"));
        } else {
            Assertions.assertEquals((Object)"bar", (Object)this.mbsc.getAttribute(on2, "Foo"));
        }
    }

    @Test
    public void testManagedEndpoint() throws Exception {
        this.assertDefaultDomain();
        this.resolveMandatoryEndpoint("direct:start", DirectEndpoint.class);
        ObjectName objName = new ObjectName(this.domainName + ":type=endpoints,*");
        Set<ObjectName> s = this.mbsc.queryNames(objName, null);
        Assertions.assertEquals((int)2, (int)s.size());
    }

    @Override
    @Test
    public void testCounters() throws Exception {
        CustomEndpoint resultEndpoint = (CustomEndpoint)this.resolveMandatoryEndpoint("custom:end", CustomEndpoint.class);
        resultEndpoint.expectedBodiesReceived(new Object[]{"<hello>world!</hello>"});
        this.sendBody("direct:start", "<hello>world!</hello>");
        resultEndpoint.assertIsSatisfied();
        this.verifyCounter(this.mbsc, new ObjectName(this.domainName + ":type=routes,*"));
    }

    @Override
    @Test
    public void testMBeansRegistered() throws Exception {
        this.assertDefaultDomain();
        Set<ObjectName> s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=endpoints,*"), null);
        Assertions.assertEquals((int)2, (int)s.size(), (String)("Could not find 2 endpoints: " + String.valueOf(s)));
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=context,*"), null);
        Assertions.assertEquals((int)1, (int)s.size(), (String)("Could not find 1 context: " + String.valueOf(s)));
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=processors,*"), null);
        Assertions.assertEquals((int)2, (int)s.size(), (String)("Could not find 1 processors: " + String.valueOf(s)));
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)s.size(), (String)("Could not find 1 route: " + String.valueOf(s)));
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").delay(10L).to("custom:end");
            }
        };
    }

    private static class CustomComponent
    extends MockComponent {
        private CustomComponent() {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return new CustomEndpoint(uri, (Component)this);
        }
    }
}

