/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.debugger.DefaultBacklogDebugger;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.BacklogDebugger;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class BacklogDebuggerStandbyTest
extends ManagementTestSupport {
    @Test
    public void testBacklogDebuggerStandby() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = new ObjectName("org.apache.camel:context=" + this.context.getManagementName() + ",type=tracer,name=BacklogDebugger");
        Assertions.assertNotNull((Object)on);
        mbeanServer.isRegistered(on);
        Boolean enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)enabled, (String)"Should not be enabled");
        Boolean standby = (Boolean)mbeanServer.getAttribute(on, "Standby");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)standby, (String)"Should be standby");
        mbeanServer.invoke(on, "enableDebugger", null, null);
        enabled = (Boolean)mbeanServer.getAttribute(on, "Enabled");
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)enabled, (String)"Should be enabled");
        mbeanServer.invoke(on, "addBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(100L);
        this.template.sendBody("seda:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Set suspended = (Set)mbeanServer.invoke(on, "suspendedBreakpointNodeIds", null, null);
            Assertions.assertNotNull((Object)suspended);
            Assertions.assertEquals((int)1, (int)suspended.size());
            Assertions.assertEquals((Object)"bar", suspended.iterator().next());
        });
        String xml = (String)mbeanServer.invoke(on, "dumpTracedMessagesAsXml", new Object[]{"bar", false}, new String[]{"java.lang.String", "boolean"});
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        Assertions.assertTrue((boolean)xml.contains("Hello World"), (String)"Should contain our body");
        Assertions.assertTrue((boolean)xml.contains("<toNode>bar</toNode>"), (String)"Should contain bar node");
        this.resetMocks();
        mock.expectedMessageCount(1);
        mbeanServer.invoke(on, "resumeBreakpoint", new Object[]{"bar"}, new String[]{"java.lang.String"});
        this.assertMockEndpointsSatisfied();
        Set nodes = (Set)mbeanServer.invoke(on, "suspendedBreakpointNodeIds", null, null);
        Assertions.assertNotNull((Object)nodes);
        Assertions.assertEquals((int)0, (int)nodes.size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                BacklogDebugger bd = DefaultBacklogDebugger.createDebugger((CamelContext)BacklogDebuggerStandbyTest.this.context);
                bd.setStandby(true);
                BacklogDebuggerStandbyTest.this.context.addService((Object)bd);
                BacklogDebuggerStandbyTest.this.context.setDebugging(Boolean.valueOf(true));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("seda:start?concurrentConsumers=2").setProperty("myProperty", (Expression)this.constant("myValue"))).id("setProp")).to("log:foo")).id("foo")).to("log:bar")).id("bar")).transform().constant((Object)"Bye World")).id("transform")).to("log:cheese?showExchangeId=true")).id("cheese")).to("mock:result")).id("result");
            }
        };
    }
}

