/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
@DisabledIfSystemProperty(named="ci.env.name", matches="github.com", disabledReason="Flaky on GitHub Actions")
public abstract class AbstractManagedThrottlerTest
extends ManagementTestSupport {
    protected Long runTestManageThrottler() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(10);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("direct:start", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName throttlerName = this.getCamelObjectName("processors", "mythrottler");
        ObjectName routeName = this.getCamelObjectName("routes", "route1");
        mbeanServer.invoke(routeName, "reset", null, null);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("direct:start", (Object)("Message " + i));
        }
        Long completed = (Long)mbeanServer.getAttribute(routeName, "ExchangesCompleted");
        Assertions.assertEquals((long)10L, (long)completed);
        Long total = (Long)mbeanServer.getAttribute(routeName, "TotalProcessingTime");
        Assertions.assertTrue((total < 1200L ? 1 : 0) != 0, (String)("Should take at most 1.2 sec: was " + total));
        mbeanServer.setAttribute(throttlerName, new Attribute("MaximumRequests", 2L));
        mbeanServer.invoke(routeName, "reset", null, null);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("direct:start", (Object)("Message " + i));
        }
        Long requests = (Long)mbeanServer.getAttribute(throttlerName, "MaximumRequests");
        Assertions.assertNotNull((Object)requests);
        Assertions.assertEquals((long)2L, (long)requests);
        completed = (Long)mbeanServer.getAttribute(routeName, "ExchangesCompleted");
        Assertions.assertEquals((long)10L, (long)completed);
        return (Long)mbeanServer.getAttribute(routeName, "TotalProcessingTime");
    }

    public void runTestThrottleAsyncVisibleViaJmx() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName routeName = this.getCamelObjectName("routes", "route3");
        mbeanServer.invoke(routeName, "reset", null, null);
        this.getMockEndpoint("mock:endAsync").expectedMessageCount(10);
        NotifyBuilder notifier = new NotifyBuilder((CamelContext)this.context).from("seda:throttleCountAsync").whenReceived(5).create();
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:throttleCountAsync", (Object)("Message " + i));
        }
        Assertions.assertTrue((boolean)notifier.matches(2L, TimeUnit.SECONDS));
        this.assertMockEndpointsSatisfied();
        Long completed = (Long)mbeanServer.getAttribute(routeName, "ExchangesCompleted");
        Assertions.assertEquals((long)10L, (long)completed);
    }

    @DisabledOnOs(value={OS.WINDOWS})
    @Test
    public void testThrottleAsyncExceptionVisableViaJmx() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName routeName = this.getCamelObjectName("routes", "route4");
        mbeanServer.invoke(routeName, "reset", null, null);
        this.getMockEndpoint("mock:endAsyncException").expectedMessageCount(10);
        NotifyBuilder notifier = new NotifyBuilder((CamelContext)this.context).from("seda:throttleCountAsyncException").whenReceived(5).create();
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:throttleCountAsyncException", (Object)("Message " + i));
        }
        Assertions.assertTrue((boolean)notifier.matches(2L, TimeUnit.SECONDS));
        this.assertMockEndpointsSatisfied();
        Thread.sleep(500L);
        Long completed = (Long)mbeanServer.getAttribute(routeName, "ExchangesCompleted");
        Assertions.assertEquals((long)0L, (long)completed);
    }

    @Test
    public void testRejectedExecution() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName routeName = this.getCamelObjectName("routes", "route2");
        mbeanServer.invoke(routeName, "reset", null, null);
        MockEndpoint mock = this.getMockEndpoint("mock:endAsyncReject");
        mock.expectedMessageCount(1);
        MockEndpoint exceptionMock = this.getMockEndpoint("mock:rejectedExceptionEndpoint1");
        exceptionMock.expectedMessageCount(9);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:throttleCountRejectExecution", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRejectedExecutionCallerRuns() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName routeName = this.getCamelObjectName("routes", "route2");
        mbeanServer.invoke(routeName, "reset", null, null);
        MockEndpoint mock = this.getMockEndpoint("mock:endAsyncRejectCallerRuns");
        mock.expectedMessageCount(10);
        MockEndpoint exceptionMock = this.getMockEndpoint("mock:rejectedExceptionEndpoint");
        exceptionMock.expectedMessageCount(0);
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("seda:throttleCountRejectExecutionCallerRuns", (Object)("Message " + i));
        }
        this.assertMockEndpointsSatisfied();
    }
}

