/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedCustomLoadBalancerTest
extends ManagementTestSupport {
    protected Registry createCamelRegistry() throws Exception {
        Registry answer = super.createCamelRegistry();
        answer.bind("myBalancer", (Object)new MyLoadBalancer());
        return answer;
    }

    @Test
    public void testManageCustomLoadBalancer() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = this.getCamelObjectName("processors", "mysend");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        Assertions.assertEquals((Object)"route1", (Object)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        Assertions.assertEquals((Object)this.context.getManagementName(), (Object)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        Assertions.assertEquals((Object)ServiceStatus.Started.name(), (Object)state);
        Integer size = (Integer)mbeanServer.getAttribute(on, "Size");
        Assertions.assertEquals((int)2, (int)size);
        String ref = (String)mbeanServer.getAttribute(on, "Ref");
        Assertions.assertEquals((Object)"myBalancer", (Object)ref);
        String name = (String)mbeanServer.getAttribute(on, "LoadBalancerClassName");
        Assertions.assertEquals((Object)MyLoadBalancer.class.getName(), (Object)name);
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((LoadBalanceDefinition)this.from("direct:start").loadBalance().custom("myBalancer").id("mysend")).to(new String[]{"mock:foo", "mock:bar"});
            }
        };
    }

    public static class MyLoadBalancer
    extends LoadBalancerSupport {
        public boolean process(Exchange exchange, AsyncCallback callback) {
            String body = (String)exchange.getIn().getBody(String.class);
            try {
                if ("x".equals(body)) {
                    ((AsyncProcessor)this.getProcessors().get(0)).process(exchange);
                } else if ("y".equals(body)) {
                    ((AsyncProcessor)this.getProcessors().get(1)).process(exchange);
                } else {
                    ((AsyncProcessor)this.getProcessors().get(2)).process(exchange);
                }
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
    }
}

