/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.HashMap;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

@DisabledOnOs(value={OS.AIX})
public class ManagedBrowsableEndpointAsXmlTest
extends ManagementTestSupport {
    @Test
    public void testBrowseableEndpointAsXmlIncludeBody() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(7);
        this.template.sendBody("direct:start", (Object)"<foo>Camel &gt; Donkey</foo>");
        this.template.sendBody("direct:start", (Object)"Camel > Donkey");
        this.template.sendBodyAndHeader("direct:start", (Object)"<foo>Camel &gt; Donkey</foo>", "name", (Object)"Me & You");
        this.template.sendBodyAndHeader("direct:start", (Object)"<foo>Camel &gt; Donkey</foo>", "title", (Object)"<title>Me &amp; You</title>");
        this.template.sendBodyAndHeader("direct:start", (Object)"Camel > Donkey", "name", (Object)"Me & You");
        this.template.sendBodyAndHeader("direct:start", (Object)123, "user", (Object)true);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("user", false);
        headers.put("uid", 123);
        headers.put("title", "Camel rocks");
        this.template.sendBodyAndHeaders("direct:start", (Object)"<animal><name>Donkey</name><age>17</age></animal>", headers);
        this.assertMockEndpointsSatisfied();
        List exchanges = this.getMockEndpoint("mock:result").getReceivedExchanges();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = this.getCamelObjectName("endpoints", "mock://result");
        String out = (String)mbeanServer.invoke(name, "browseMessageAsXml", new Object[]{0, true}, new String[]{"java.lang.Integer", "java.lang.Boolean"});
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        Assertions.assertEquals((Object)("<message exchangeId=\"" + ((Exchange)exchanges.get(0)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <body type=\"java.lang.String\">&lt;foo&gt;Camel &amp;gt; Donkey&lt;/foo&gt;</body>\n</message>"), (Object)out);
        out = (String)mbeanServer.invoke(name, "browseMessageAsXml", new Object[]{1, true}, new String[]{"java.lang.Integer", "java.lang.Boolean"});
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        Assertions.assertEquals((Object)("<message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <body type=\"java.lang.String\">Camel &gt; Donkey</body>\n</message>"), (Object)out);
        out = (String)mbeanServer.invoke(name, "browseMessageAsXml", new Object[]{2, true}, new String[]{"java.lang.Integer", "java.lang.Boolean"});
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        Assertions.assertEquals((Object)("<message exchangeId=\"" + ((Exchange)exchanges.get(2)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <headers>\n    <header key=\"name\" type=\"java.lang.String\">Me &amp; You</header>\n  </headers>\n  <body type=\"java.lang.String\">&lt;foo&gt;Camel &amp;gt; Donkey&lt;/foo&gt;</body>\n</message>"), (Object)out);
        out = (String)mbeanServer.invoke(name, "browseMessageAsXml", new Object[]{3, true}, new String[]{"java.lang.Integer", "java.lang.Boolean"});
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        Assertions.assertEquals((Object)("<message exchangeId=\"" + ((Exchange)exchanges.get(3)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <headers>\n    <header key=\"title\" type=\"java.lang.String\">&lt;title&gt;Me &amp;amp; You&lt;/title&gt;</header>\n  </headers>\n  <body type=\"java.lang.String\">&lt;foo&gt;Camel &amp;gt; Donkey&lt;/foo&gt;</body>\n</message>"), (Object)out);
        out = (String)mbeanServer.invoke(name, "browseMessageAsXml", new Object[]{4, true}, new String[]{"java.lang.Integer", "java.lang.Boolean"});
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        Assertions.assertEquals((Object)("<message exchangeId=\"" + ((Exchange)exchanges.get(4)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <headers>\n    <header key=\"name\" type=\"java.lang.String\">Me &amp; You</header>\n  </headers>\n  <body type=\"java.lang.String\">Camel &gt; Donkey</body>\n</message>"), (Object)out);
        out = (String)mbeanServer.invoke(name, "browseMessageAsXml", new Object[]{5, true}, new String[]{"java.lang.Integer", "java.lang.Boolean"});
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        Assertions.assertEquals((Object)("<message exchangeId=\"" + ((Exchange)exchanges.get(5)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <headers>\n    <header key=\"user\" type=\"java.lang.Boolean\">true</header>\n  </headers>\n  <body type=\"java.lang.Integer\">123</body>\n</message>"), (Object)out);
        out = (String)mbeanServer.invoke(name, "browseMessageAsXml", new Object[]{6, true}, new String[]{"java.lang.Integer", "java.lang.Boolean"});
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        Assertions.assertEquals((Object)("<message exchangeId=\"" + ((Exchange)exchanges.get(6)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <headers>\n    <header key=\"title\" type=\"java.lang.String\">Camel rocks</header>\n    <header key=\"uid\" type=\"java.lang.Integer\">123</header>\n    <header key=\"user\" type=\"java.lang.Boolean\">false</header>\n  </headers>\n  <body type=\"java.lang.String\">&lt;animal&gt;&lt;name&gt;Donkey&lt;/name&gt;&lt;age&gt;17&lt;/age&gt;&lt;/animal&gt;</body>\n</message>"), (Object)out);
    }

    @Test
    public void testBrowseableEndpointAsXml() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)456);
        this.assertMockEndpointsSatisfied();
        List exchanges = this.getMockEndpoint("mock:result").getReceivedExchanges();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = this.getCamelObjectName("endpoints", "mock://result");
        String out = (String)mbeanServer.invoke(name, "browseMessageAsXml", new Object[]{0, false}, new String[]{"java.lang.Integer", "java.lang.Boolean"});
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        Assertions.assertEquals((Object)("<message exchangeId=\"" + ((Exchange)exchanges.get(0)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <headers>\n    <header key=\"foo\" type=\"java.lang.Integer\">123</header>\n  </headers>\n</message>"), (Object)out);
        out = (String)mbeanServer.invoke(name, "browseMessageAsXml", new Object[]{1, false}, new String[]{"java.lang.Integer", "java.lang.Boolean"});
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        Assertions.assertEquals((Object)("<message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <headers>\n    <header key=\"foo\" type=\"java.lang.Integer\">456</header>\n  </headers>\n</message>"), (Object)out);
    }

    @Test
    public void testBrowseableEndpointAsXmlAllIncludeBody() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)456);
        this.assertMockEndpointsSatisfied();
        List exchanges = this.getMockEndpoint("mock:result").getReceivedExchanges();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = this.getCamelObjectName("endpoints", "mock://result");
        String out = (String)mbeanServer.invoke(name, "browseAllMessagesAsXml", new Object[]{true}, new String[]{"java.lang.Boolean"});
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        Assertions.assertEquals((Object)("<messages>\n<message exchangeId=\"" + ((Exchange)exchanges.get(0)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <body type=\"java.lang.String\">Hello World</body>\n</message>\n<message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <headers>\n    <header key=\"foo\" type=\"java.lang.Integer\">456</header>\n  </headers>\n  <body type=\"java.lang.String\">Bye World</body>\n</message>\n</messages>"), (Object)out);
    }

    @Test
    public void testBrowseableEndpointAsXmlAll() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(2);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)456);
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        List exchanges = this.getMockEndpoint("mock:result").getReceivedExchanges();
        ObjectName name = this.getCamelObjectName("endpoints", "mock://result");
        String out = (String)mbeanServer.invoke(name, "browseAllMessagesAsXml", new Object[]{false}, new String[]{"java.lang.Boolean"});
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        Assertions.assertEquals((Object)("<messages>\n<message exchangeId=\"" + ((Exchange)exchanges.get(0)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <headers>\n    <header key=\"foo\" type=\"java.lang.Integer\">123</header>\n  </headers>\n</message>\n<message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <headers>\n    <header key=\"foo\" type=\"java.lang.Integer\">456</header>\n  </headers>\n</message>\n</messages>"), (Object)out);
    }

    @Test
    public void testBrowseableEndpointAsXmlRangeIncludeBody() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(3);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)456);
        this.template.sendBody("direct:start", (Object)"Hi Camel");
        this.assertMockEndpointsSatisfied();
        List exchanges = this.getMockEndpoint("mock:result").getReceivedExchanges();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = this.getCamelObjectName("endpoints", "mock://result");
        String out = (String)mbeanServer.invoke(name, "browseRangeMessagesAsXml", new Object[]{0, 1, true}, new String[]{"java.lang.Integer", "java.lang.Integer", "java.lang.Boolean"});
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        Assertions.assertEquals((Object)("<messages>\n<message exchangeId=\"" + ((Exchange)exchanges.get(0)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <body type=\"java.lang.String\">Hello World</body>\n</message>\n<message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <headers>\n    <header key=\"foo\" type=\"java.lang.Integer\">456</header>\n  </headers>\n  <body type=\"java.lang.String\">Bye World</body>\n</message>\n</messages>"), (Object)out);
    }

    @Test
    public void testBrowseableEndpointAsXmlRange() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(3);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)123);
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)456);
        this.template.sendBody("direct:start", (Object)"Hi Camel");
        this.assertMockEndpointsSatisfied();
        List exchanges = this.getMockEndpoint("mock:result").getReceivedExchanges();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = this.getCamelObjectName("endpoints", "mock://result");
        String out = (String)mbeanServer.invoke(name, "browseRangeMessagesAsXml", new Object[]{0, 1, false}, new String[]{"java.lang.Integer", "java.lang.Integer", "java.lang.Boolean"});
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        Assertions.assertEquals((Object)("<messages>\n<message exchangeId=\"" + ((Exchange)exchanges.get(0)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <headers>\n    <header key=\"foo\" type=\"java.lang.Integer\">123</header>\n  </headers>\n</message>\n<message exchangeId=\"" + ((Exchange)exchanges.get(1)).getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <headers>\n    <header key=\"foo\" type=\"java.lang.Integer\">456</header>\n  </headers>\n</message>\n</messages>"), (Object)out);
    }

    @Test
    public void testBrowseableEndpointAsXmlRangeInvalidIndex() throws Exception {
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName name = this.getCamelObjectName("endpoints", "mock://result");
        try {
            mbeanServer.invoke(name, "browseRangeMessagesAsXml", new Object[]{3, 1, false}, new String[]{"java.lang.Integer", "java.lang.Integer", "java.lang.Boolean"});
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (Exception e) {
            ManagedBrowsableEndpointAsXmlTest.assertIsInstanceOf(IllegalArgumentException.class, (Object)e.getCause());
            Assertions.assertEquals((Object)"From index cannot be larger than to index, was: 3 > 1", (Object)e.getCause().getMessage());
        }
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ManagedBrowsableEndpointAsXmlTest.this.context.setUseBreadcrumb(Boolean.valueOf(false));
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

