/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.parallel.ResourceLock;

@ResourceLock(value="java.lang.System.properties")
@DisabledOnOs(value={OS.AIX})
public class JmxInstrumentationUsingDefaultsTest
extends ManagementTestSupport {
    protected String domainName = "org.apache.camel";
    protected MBeanServerConnection mbsc;

    protected void assertDefaultDomain() throws IOException {
        if (System.getProperty("org.apache.camel.jmx.usePlatformMBeanServer") != null && !Boolean.getBoolean("org.apache.camel.jmx.usePlatformMBeanServer")) {
            Assertions.assertEquals((Object)this.domainName, (Object)this.mbsc.getDefaultDomain());
        }
    }

    @Test
    public void testMBeansRegistered() throws Exception {
        this.assertDefaultDomain();
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.resolveMandatoryEndpoint("mock:end", MockEndpoint.class);
        Set<ObjectName> s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=endpoints,*"), null);
        Assertions.assertEquals((int)2, (int)s.size(), (String)("Could not find 2 endpoints: " + String.valueOf(s)));
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=context,*"), null);
        Assertions.assertEquals((int)1, (int)s.size(), (String)("Could not find 1 context: " + String.valueOf(s)));
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=processors,*"), null);
        Assertions.assertEquals((int)2, (int)s.size(), (String)("Could not find 1 processors: " + String.valueOf(s)));
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=consumers,*"), null);
        Assertions.assertEquals((int)1, (int)s.size(), (String)("Could not find 1 consumers: " + String.valueOf(s)));
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=producers,*"), null);
        Assertions.assertEquals((int)1, (int)s.size(), (String)("Could not find 1 producers: " + String.valueOf(s)));
        s = this.mbsc.queryNames(new ObjectName(this.domainName + ":type=routes,*"), null);
        Assertions.assertEquals((int)1, (int)s.size(), (String)("Could not find 1 route: " + String.valueOf(s)));
    }

    @Test
    public void testCounters() throws Exception {
        MockEndpoint resultEndpoint = (MockEndpoint)this.resolveMandatoryEndpoint("mock:end", MockEndpoint.class);
        resultEndpoint.expectedBodiesReceived(new Object[]{"<hello>world!</hello>"});
        this.sendBody("direct:start", "<hello>world!</hello>");
        resultEndpoint.assertIsSatisfied();
        this.verifyCounter(this.mbsc, new ObjectName(this.domainName + ":type=routes,*"));
    }

    protected void verifyCounter(MBeanServerConnection beanServer, ObjectName name) throws Exception {
        Set<ObjectName> s = beanServer.queryNames(name, null);
        Assertions.assertEquals((int)1, (int)s.size(), (String)("Found mbeans: " + String.valueOf(s)));
        Iterator<ObjectName> iter = s.iterator();
        ObjectName pcob = iter.next();
        Long valueofNumExchanges = (Long)beanServer.getAttribute(pcob, "ExchangesTotal");
        Assertions.assertNotNull((Object)valueofNumExchanges, (String)"Expected attribute found. MBean registered under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class");
        Assertions.assertEquals((Long)1L, (Long)valueofNumExchanges);
        Long valueofNumCompleted = (Long)beanServer.getAttribute(pcob, "ExchangesCompleted");
        Assertions.assertNotNull((Object)valueofNumCompleted, (String)"Expected attribute found. MBean registered under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class");
        Assertions.assertEquals((Long)1L, (Long)valueofNumCompleted);
        Long valueofNumFailed = (Long)beanServer.getAttribute(pcob, "ExchangesFailed");
        Assertions.assertNotNull((Object)valueofNumFailed, (String)"Expected attribute found. MBean registered under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class");
        Assertions.assertEquals((Long)0L, (Long)valueofNumFailed);
        Long valueofMinProcessingTime = (Long)beanServer.getAttribute(pcob, "MinProcessingTime");
        Assertions.assertNotNull((Object)valueofMinProcessingTime, (String)"Expected attribute found. MBean registered under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class");
        Assertions.assertTrue((valueofMinProcessingTime >= 0L ? 1 : 0) != 0);
        Long valueofMaxProcessingTime = (Long)beanServer.getAttribute(pcob, "MaxProcessingTime");
        Assertions.assertNotNull((Object)valueofMaxProcessingTime, (String)"Expected attribute found. MBean registered under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class");
        Assertions.assertTrue((valueofMaxProcessingTime >= 0L ? 1 : 0) != 0);
        Long valueofMeanProcessingTime = (Long)beanServer.getAttribute(pcob, "MeanProcessingTime");
        Assertions.assertNotNull((Object)valueofMeanProcessingTime, (String)"Expected attribute found. MBean registered under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class");
        Assertions.assertTrue((valueofMeanProcessingTime >= valueofMinProcessingTime && valueofMeanProcessingTime <= valueofMaxProcessingTime ? 1 : 0) != 0);
        Long totalProcessingTime = (Long)beanServer.getAttribute(pcob, "TotalProcessingTime");
        Assertions.assertNotNull((Object)totalProcessingTime, (String)"Expected attribute found. MBean registered under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class");
        Assertions.assertTrue((totalProcessingTime >= 0L ? 1 : 0) != 0);
        Long lastProcessingTime = (Long)beanServer.getAttribute(pcob, "LastProcessingTime");
        Assertions.assertNotNull((Object)lastProcessingTime, (String)"Expected attribute found. MBean registered under a '<domain>:name=Stats,*' key must be of type PerformanceCounter.class");
        Assertions.assertTrue((lastProcessingTime >= 0L ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)beanServer.getAttribute(pcob, "FirstExchangeCompletedTimestamp"), (String)"Expected first completion time to be available");
        Assertions.assertNotNull((Object)beanServer.getAttribute(pcob, "LastExchangeCompletedTimestamp"), (String)"Expected last completion time to be available");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").delay(10L).to("mock:end");
            }
        };
    }

    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Awaitility.await().atMost(3L, TimeUnit.SECONDS).ignoreExceptions().until(() -> {
            this.mbsc = this.getMBeanConnection();
            return true;
        });
    }

    @AfterEach
    public void tearDown() throws Exception {
        try {
            super.tearDown();
            this.mbsc = null;
        }
        finally {
            System.clearProperty("org.apache.camel.jmx.usePlatformMBeanServer");
            System.clearProperty("org.apache.camel.jmx.mbeanServerDefaultDomain");
            System.clearProperty("org.apache.camel.jmx.mbeanObjectDomainName");
        }
    }

    protected MBeanServerConnection getMBeanConnection() throws Exception {
        return this.context.getManagementStrategy().getManagementAgent().getMBeanServer();
    }
}

