/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedTypeConverterRegistryMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.TypeConverterRegistry;

@ManagedResource(description="Managed TypeConverterRegistry")
public class ManagedTypeConverterRegistry
extends ManagedService
implements ManagedTypeConverterRegistryMBean {
    private final TypeConverterRegistry registry;

    public ManagedTypeConverterRegistry(CamelContext context, TypeConverterRegistry registry) {
        super(context, (Service)registry);
        this.registry = registry;
    }

    public TypeConverterRegistry getRegistry() {
        return this.registry;
    }

    public long getNoopCounter() {
        return this.registry.getStatistics().getNoopCounter();
    }

    public long getAttemptCounter() {
        return this.registry.getStatistics().getAttemptCounter();
    }

    public long getHitCounter() {
        return this.registry.getStatistics().getHitCounter();
    }

    public long getMissCounter() {
        return this.registry.getStatistics().getMissCounter();
    }

    public long getFailedCounter() {
        return this.registry.getStatistics().getFailedCounter();
    }

    public void resetTypeConversionCounters() {
        this.registry.getStatistics().reset();
    }

    public int getNumberOfTypeConverters() {
        return this.registry.size();
    }

    public String getTypeConverterExistsLoggingLevel() {
        return this.registry.getTypeConverterExistsLoggingLevel().name();
    }

    public String getTypeConverterExists() {
        return this.registry.getTypeConverterExists().name();
    }

    public boolean hasTypeConverter(String fromType, String toType) {
        try {
            Class from = this.getContext().getClassResolver().resolveMandatoryClass(fromType);
            Class to = this.getContext().getClassResolver().resolveMandatoryClass(toType);
            return this.registry.lookup(to, from) != null;
        }
        catch (ClassNotFoundException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

