/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.LoggingLevel;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedSchedulePollConsumerMBean;
import org.apache.camel.management.mbean.ManagedConsumer;
import org.apache.camel.support.ScheduledPollConsumer;

@ManagedResource(description="Managed Scheduled Polling Consumer")
public class ManagedScheduledPollConsumer
extends ManagedConsumer
implements ManagedSchedulePollConsumerMBean {
    private final ScheduledPollConsumer consumer;

    public ManagedScheduledPollConsumer(CamelContext context, ScheduledPollConsumer consumer) {
        super(context, (Consumer)consumer);
        this.consumer = consumer;
    }

    public ScheduledPollConsumer getConsumer() {
        return this.consumer;
    }

    public long getDelay() {
        return this.getConsumer().getDelay();
    }

    public void setDelay(long delay) {
        this.getConsumer().setDelay(delay);
    }

    public long getInitialDelay() {
        return this.getConsumer().getInitialDelay();
    }

    public void setInitialDelay(long initialDelay) {
        this.getConsumer().setInitialDelay(initialDelay);
    }

    public boolean isUseFixedDelay() {
        return this.getConsumer().isUseFixedDelay();
    }

    public void setUseFixedDelay(boolean useFixedDelay) {
        this.getConsumer().setUseFixedDelay(useFixedDelay);
    }

    public boolean isGreedy() {
        return this.getConsumer().isGreedy();
    }

    public void setGreedy(boolean greedy) {
        this.getConsumer().setGreedy(greedy);
    }

    public boolean isSendEmptyMessageWhenIdle() {
        return this.getConsumer().isSendEmptyMessageWhenIdle();
    }

    public void setSendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
        this.getConsumer().setSendEmptyMessageWhenIdle(sendEmptyMessageWhenIdle);
    }

    public String getRunningLoggingLevel() {
        return this.getConsumer().getRunLoggingLevel().name();
    }

    public void setRunningLoggingLevel(String runningLoggingLevel) {
        this.getConsumer().setRunLoggingLevel(LoggingLevel.valueOf((String)runningLoggingLevel));
    }

    public String getTimeUnit() {
        return this.getConsumer().getTimeUnit().name();
    }

    public void setTimeUnit(String timeUnit) {
        this.getConsumer().setTimeUnit(TimeUnit.valueOf(timeUnit));
    }

    public boolean isPolling() {
        return this.getConsumer().isPolling();
    }

    public boolean isSchedulerStarted() {
        return this.getConsumer().isSchedulerStarted();
    }

    public void startScheduler() {
        this.getConsumer().startScheduler();
    }

    public String getSchedulerClassName() {
        return this.getConsumer().getScheduler().getClass().getName();
    }

    public int getBackoffMultiplier() {
        return this.getConsumer().getBackoffMultiplier();
    }

    public int getBackoffIdleThreshold() {
        return this.getConsumer().getBackoffIdleThreshold();
    }

    public int getBackoffErrorThreshold() {
        return this.getConsumer().getBackoffErrorThreshold();
    }

    public int getBackoffCounter() {
        return this.getConsumer().getBackoffCounter();
    }

    public long getRepeatCount() {
        return this.getConsumer().getRepeatCount();
    }

    public boolean isFirstPollDone() {
        return this.getConsumer().isFirstPollDone();
    }

    public boolean isConsumerReady() {
        return this.getConsumer().isConsumerReady();
    }

    public long getCounter() {
        return this.getConsumer().getCounter();
    }

    public long getErrorCounter() {
        return this.getConsumer().getErrorCounter();
    }

    public long getSuccessCounter() {
        return this.getConsumer().getSuccessCounter();
    }
}

