/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AvailablePortFinder {
    private static final Logger LOG = LoggerFactory.getLogger(AvailablePortFinder.class);

    private AvailablePortFinder() {
    }

    public static int getNextAvailable() {
        int n;
        ServerSocket ss = new ServerSocket();
        try {
            ss.setReuseAddress(true);
            ss.bind(new InetSocketAddress((InetAddress)null, 0), 1);
            int port = ss.getLocalPort();
            LOG.info("getNextAvailable() -> {}", (Object)port);
            n = port;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot find free port", e);
            }
        }
        ss.close();
        return n;
    }
}

